/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2017 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : Mike Heck (Dec 2007)
**=======================================================================*/

// Utility Function: Compute total size of an LDM volume
//
// For example, disk space needed to convert a volume to LDM
//
// volDim : Volume dimensions (voxels)
// tileDim: Tile dimensions (voxels)
// overlap: Tile overlap (voxels)
// bytesPV: Bytes per voxel
//

int64_t sizeOfLdmData( const SbVec3i32 volDim,
                       const SbVec3i32 tileDim,
                       int overlap, int bytesPV )
{
  // Compute number of full resolution tiles (level 0)
  int xtiles = (int)ceil( (float)volDim[0] / (tileDim[0] - overlap));
  int ytiles = (int)ceil( (float)volDim[1] / (tileDim[1] - overlap));
  int ztiles = (int)ceil( (float)volDim[2] / (tileDim[2] - overlap));
  size_t numTiles = xtiles * ytiles * ztiles;

  // Loop over resolution levels
  // Each level combines blocks of 8 tiles into 1 tile.
  // The easiest way is divide the number of tiles per axis by 2,
  // rounding up the result to account for partial blocks.
  // When we get down to 1 tile that must be the root level.
  size_t totalTiles = numTiles;
  while (numTiles > 1) {
    xtiles = (int)ceil( (float)xtiles / 2);
    ytiles = (int)ceil( (float)ytiles / 2);
    ztiles = (int)ceil( (float)ztiles / 2);
    numTiles = xtiles * ytiles * ztiles;
    totalTiles += numTiles;
  }

  // Compute total bytes of LDM data
  size_t  bytesPerTile = tileDim[0] * tileDim[1] * tileDim[2] * bytesPV;
  int64_t totalBytes   = bytesPerTile * totalTiles;

  return totalBytes;
}

