#if !defined COMPUTE_H
#define COMPUTE_H

#include <Inventor/SbDataType.h>
#include <Inventor/devices/SoDeviceContext.h>

class SoBufferObject;

class SoCpuContext;
class SoAlgorithms;

class SoConvolution;
class SoConversion;
class SoArithmetic;
class SoSeismic;
class SoConvolutionHandle;

// Define dynamic parameters we want to exchange between 
// application and compute processing function
struct ComputeParameters
{
public:
  // Default Constructor
  ComputeParameters()
  {
    inputData = NULL;
    outputData = NULL;

    width = 0;   
    height = 0;
    //SbDataType inputDataType;
    //dataMin;
    //dataMax;

    dumpToPng = false;
  }

public:
  SoBufferObject*  inputData;
  SbDataType inputDataType;

  SoBufferObject*  outputData;

  int    width;       
  int    height;
  
  int attribute;

  float dataMin;
  float dataMax;

  bool dumpToPng;
};

class Compute
{
public:

  /**
   * Default constructor.
   */
  Compute();

  /**
   * Default destructor.
   */
  ~Compute();

  /**
   * launch computation on current input/output buffers.
   */
  SbBool doCompute( ComputeParameters* parameters );

  /**
   * Create buffer object depending on algorithms module loaded.
   * SoCPUBufferObject by default.
   */
  SoBufferObject* createBufferObject( size_t size );

private:

  SoRef<SoDeviceContext> m_deviceContext;

  SoConvolution* m_convolutionAlgorithms;
  SoConversion* m_conversionAlgorithms;
  SoArithmetic* m_arithmeticAlgorithms;
  SoSeismic* m_seismicAlgorithms;

  SoBufferObject* m_outputBufferObject;
  SoBufferObject* m_tmpBufferObject;

  SoAlgorithms* m_algorithmsInterface;

};

#endif //COMPUTE_H

