/*----------------------------------------------------------------------------------------
Example program.
Purpose : Demonstrate how to create a custome reader
----------------------------------------------------------------------------------------*/

//header files
#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>
#include <Inventor/nodes/SoSeparator.h>
#include <VolumeViz/nodes/SoVolumeData.h>
#include <VolumeViz/nodes/SoVolumeRender.h>
#include <LDM/nodes/SoTransferFunction.h>
#include <LDM/SoLDMTopoOctree.h>
#include <VolumeViz/nodes/SoVolumeRendering.h>
#include <LDM/manips/SoROIManip.h>
#include <LDM/SoLDMResourceManager.h>
#include <Inventor/events/SoKeyboardEvent.h>
#include <Inventor/nodes/SoPerspectiveCamera.h>
#include <Inventor/nodes/SoCube.h>
#include <Inventor/nodes/SoFont.h>
#include <Inventor/nodes/SoText2.h>
#include <Inventor/nodes/SoTranslation.h>
#include <Inventor/nodes/SoLightModel.h>
#include <Inventor/nodes/SoDrawStyle.h>
#include <Inventor/nodes/SoBaseColor.h>
#include <Inventor/nodes/SoLineSet.h>
#include <Inventor/nodes/SoVertexProperty.h>
#include <Inventor/nodes/SoSwitch.h>
#include <Inventor/nodes/SoEventCallback.h>
#include <Inventor/sensors/SoNodeSensor.h>

#include "SoDataAccessReader.h"

bool  toggleViewData = true;
bool  updateData = false;
int   resolution = 0;

SoXtExaminerViewer* myViewer2 = NULL;
SoSeparator*             root = NULL;
SoSeparator*            root2 = NULL;
SoSeparator*           boxSep = NULL;
SoVolumeData*        pVolData = NULL;
SoROIManip*         pROIManip = NULL;
SoVolumeData*         volData = NULL;
SoSwitch      *switchViewData = NULL;


////////////////////////////////////////////////////////////////////////
//
void
EventCB (void *, SoEventCallback *eventCB)
{
  const SoEvent *event = eventCB->getEvent();

  // Toggle data display
  if (SO_KEY_PRESS_EVENT(event, D)) {
    toggleViewData = !toggleViewData;
    updateData = true;
  }

  // Update data
  else if (SO_KEY_PRESS_EVENT(event, U)) {
    updateData = true;
  }

  // increase resolution
  else if (SO_KEY_PRESS_EVENT(event, UP_ARROW)) {
    if (resolution)
      resolution--;
    updateData = true;
  }

  // decrease resolution
  else if (SO_KEY_PRESS_EVENT(event, DOWN_ARROW))
  {
    if ( resolution < pVolData->getLDMTopoOctree()->getLevelMax() )
      resolution++;
    updateData = true;
  }

  else {
    return;
  }

  pROIManip->touch(); // to force viewer2 to be updated
}

////////////////////////////////////////////////////////////////////////
//
// main function
int main(int, char **argv)
{
  // Create the window
  Widget myWindow = SoXt::init(argv[0]);
  if (!myWindow) return 0;

  // Initialize of VolumeViz extension
  SoVolumeRendering::init();
  SoDataAccessReader::initClass();

  SbString envVar = SbString("OIV_USER_LIBS");
  SbString pathToCustomNode = "$OIVHOME/examples/bin/$OIVARCH/VolumeViz/SoDataAccessReader";
  SoPreferences::setString(envVar, pathToCustomNode);
  
  // Node to hold the volume data
  pVolData = new SoVolumeData();
  pVolData->fileName = "$OIVHOME/examples/data/VolumeViz/colt-float.ldm";

  // Track the keyboard events
  SoEventCallback *eventCB = new SoEventCallback;
  eventCB->addEventCallback( SoKeyboardEvent::getClassTypeId(), EventCB, NULL );

  // Use a predefined colorMap with the SoTransferFunction
  SoTransferFunction *pTransFunc = new SoTransferFunction;
  pTransFunc->predefColorMap = SoTransferFunction::SEISMIC;
  pTransFunc->minValue = 15;
  pTransFunc->maxValue = 255;

  // ROI / ROIManip
  // Initialize both ROI box and subvolume to be the entire volume.
  // Constrain the ROIManip to stay inside the volume.
   SbVec3i32 dimensions = pVolData->data.getSize();

  pVolData->ldmResourceParameters.getValue()->loadPolicy = SoVolumeData::SoLDMResourceParameters::ALWAYS;
  pROIManip = new SoROIManip();
  pROIManip->box.setValue( SbVec3i32(0,0,0), dimensions - SbVec3i32(1,1,1) );
  pROIManip->subVolume.setValue( SbVec3i32(0,0,0), dimensions - SbVec3i32(1,1,1) );
  pROIManip->constrained = TRUE;
  pROIManip->boxOn = FALSE;

  // Node in charge of drawing the volume
  SoVolumeRender* pVolRender = new SoVolumeRender;
  pVolRender->samplingAlignment = SoVolumeRender::DATA_ALIGNED;

  // Assemble the scene graph
  // Note: SoVolumeRender must appear after the SoVolumeData node.
  SoSeparator *root = new SoSeparator;
  root->ref();
  root->addChild( eventCB );
  root->addChild( pVolData );
  root->addChild( pROIManip );
  root->addChild( pTransFunc );
  root->addChild( pVolRender );

  // Set up viewer 1:
  SoXtExaminerViewer *myViewer1 = new SoXtExaminerViewer(myWindow);
  myViewer1->setSceneGraph(root);
  myViewer1->setTitle("Volume rendering");
  myViewer1->show();

  // Node to hold the volume data access
  SoDataAccessReader *dataAccessReader = new SoDataAccessReader;
  dataAccessReader->inputVolumeData = pVolData;

  SoVolumeData *pVolData2 = new SoVolumeData();
  pVolData2->setReader(*dataAccessReader);

  // Node in charge of drawing the volume
  SoVolumeRender* pVolRender2 = new SoVolumeRender;

  // Use a predefined colorMap with the SoTransferFunction
  SoTransferFunction *pTransFunc2 = new SoTransferFunction;
  pTransFunc2->predefColorMap = SoTransferFunction::SEISMIC;
  pTransFunc2->minValue = 15;
  pTransFunc2->maxValue = 255;

  // Assemble the scene graph
  SoSeparator *root2 = new SoSeparator;
  root2->ref();
  root2->addChild( pVolData2 );
  root2->addChild( pTransFunc2 );
  root2->addChild( pVolRender2 );

  // Set up viewer 2:
  myViewer2 = new SoXtExaminerViewer(myWindow, "", FALSE);
  myViewer2->setSceneGraph(root2);
  myViewer2->setTitle("GetData( box )");
  myViewer2->setBackgroundColor( SbColor(0.4f,0.4f,0.4f) );

  myViewer2->show();

  //
  SoXt::show(myWindow);
  SoXt::mainLoop();
  delete myViewer1;
  delete myViewer2;
  root->unref();

  SoDataAccessReader::exitClass();
  SoVolumeRendering::finish();
  SoXt::finish();

  return 0;
}


