/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2020 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : David BEILLOIN (Sep 2008)
**=======================================================================*/


#ifndef _SO_DATA_ACCESS_READER_H
#define _SO_DATA_ACCESS_READER_H

#include <Inventor/SbLinear.h>
#include <Inventor/STL/map>
#include <Inventor/STL/list>

#include <Inventor/nodes/SoNode.h>
#include <Inventor/fields/SoSubField.h>
//#include <Inventor/fields/SoSubFieldContainer.h>

#include <Inventor/fields/SoSFNode.h>
#include <Inventor/fields/SoSFInt32.h>
#include <Inventor/fields/SoSFUInt32.h>
#include <Inventor/fields/SoSFEnum.h>
#include <Inventor/fields/SoSFFilePathString.h>
#include <Inventor/threads/SbThread.h>
#include <Inventor/threads/SbThreadMutex.h>
#include <VolumeViz/nodes/SoVolumeData.h>
#include <VolumeViz/readers/SoVolumeReader.h>

// When building the node as a DLL under Win32 we must explicitly
// declare this entry point as visible outside the DLL.
// The macro BUILDING_DLL is defined in the node's source file.
#ifdef BUILDING_DLL
  #define DLL_EXPORT VC_DLL_EXPORT
#else
  #define DLL_EXPORT VC_DLL_IMPORT
#endif

#ifdef _MSC_VER
#pragma warning( push )
#pragma warning(disable:4251)
#endif

class DLL_EXPORT SoDataAccessReader : public SoVolumeReader
{
  SO_FIELDCONTAINER_HEADER(SoDataAccessReader);

public:

  /** Default Constructor. */
  SoDataAccessReader();

  /** reference to the VolumeData from wichi we want to load our own tiles. */
  SoSFNode inputVolumeData;

  /** Standard reader stuf redefine */
  virtual SoVolumeReader::ReadError getDataChar( SbBox3f &size, SoVolumeData::DataType &type, SbVec3i32 &dim );
  virtual SbBool getTileSize (SbVec3i32 &size);
  //Obsolete: virtual SbBool getMinMax(int & min, int & max);
  virtual SbBool getMinMax(double & min, double & max);
  virtual SbBool getMinMax(int64_t & min, int64_t & max);
  virtual SoCpuBufferObject* readTile (int index, const SbBox3i32& tilePosition);
  virtual void getSubSlice( const SbBox2i32& subSlice, int sliceNumber, void * data );
  virtual SbBool isThreadSafe() const;
  virtual SbBool isDataConverted() const { return TRUE; }

protected:
  /** Destructor */
  ~SoDataAccessReader();

  /** keep track of fields change */
  virtual void notify(SoNotList *list);

  /** return LDM index from position */
  int getTileIndex(const SbVec3i32& cellPos, int resolution );

  /** return position from LDM index */
  SbBox3i32 getTilePos(const SoLDMTileID tileID);


private:
  /** Internal method to build tile that bounds out of the volume */
  void buildTile( const SbBox3i32& subVolume, const void* subVolumeBuffer, const SbBox3i32& tilePos, void* tileData, const SbBox3i32& intersection );
  template <typename T> void fillTile(void* ptrDst, int size, void* value );
};

#ifdef _MSC_VER
#pragma warning( pop )
#endif

#endif /* _SO_DATA_ACCESS_READER_H */

