/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2020 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : David BEILLOIN (Dec 2008)
**=======================================================================*/
#define BUILDING_DLL 1
#include "CustomLDMReader.h"

#include <string.h>

#include <Inventor/fields/SoSubFieldContainer.h>
#include <Inventor/threads/SbThreadMutex.h>
#include <Inventor/threads/SbThreadRWMutex.h>
#include <Inventor/SbElapsedTime.h>
#include <Inventor/SbMathHelper.h>
#include <Inventor/helpers/SbDataTypeMacros.h>
#include <Inventor/helpers/SbFileHelper.h>
#include <Inventor/devices/SoCpuBufferObject.h>

#include <LDM/SoLDMTopoOctree.h>

#if defined(WIN32)
#define strcasecmp _stricmp
#endif

SO_FIELDCONTAINER_SOURCE(CustomLDMReader);

void CustomLDMReader::initClass()
{
  SO_FIELDCONTAINER_INIT_CLASS(CustomLDMReader, "CustomLDMReader", SoVolumeReader);
}

void CustomLDMReader::exitClass()
{
  SO__FIELDCONTAINER_EXIT_CLASS(CustomLDMReader);
}


CustomLDMReader::CustomLDMReader()
{
	SO_FIELDCONTAINER_CONSTRUCTOR(CustomLDMReader);

  
  m_size.setBounds(-1.0f, -1.0f, -1.0f, 1.0f, 1.0f, 1.0f);
  m_dim.setValue(0,0,0); 
  m_type = SoVolumeData::UNSIGNED_BYTE; 
  m_bytesPerVoxel = 1; 
  m_tileDim.setValue(16,16,16);

  m_tileBytes = m_tileDim[0]*m_tileDim[1]*m_tileDim[2]*m_bytesPerVoxel;

  m_fp = NULL;
  m_topo = NULL;
}

CustomLDMReader::~CustomLDMReader()
{
	fclose(m_fp);
  delete m_topo;
}
 
//void 
//CustomLDMReader::setUserData( void *data )
//{
//    if ( data!=NULL)
//      fprintf(stderr,"setUserData %s\n",(char*)data);
//}

int 
CustomLDMReader::setFilename(const SbString& filename)
{
	if (m_fp == NULL) 
  {
    SbString expandPath = SbFileHelper::expandString(filename);

		m_fp = fopen(expandPath.getString(),"r");

    if ( !m_fp )
      return FALSE;

    char Line[1024];
		int i1,i2,i3;
		float f1,f2,f3,f4,f5,f6;

    if (m_fp) 
    {
			fgets(Line,1024,m_fp);
			//scan dimension of matrix
			sscanf(Line,"%d %d %d",&i1,&i2,&i3);

			m_dim.setValue(i1,i2,i3); 
			printf("matrix: [%d %d %d]\n",i1,i2,i3);

			fgets(Line,1024,m_fp);
			//scan position of volume
			sscanf(Line,"%f %f %f %f %f %f",&f1,&f2,&f3,&f4,&f5,&f6);
			m_size.setBounds(f1, f2, f3, f4, f5, f6);

			printf("bounds: [%f %f %f][%f %f %f]\n",f1, f2, f3, f4, f5, f6);

		}

		  m_tileDim.setValue(64,64,64);

		  m_type = SoDataSet::UNSIGNED_BYTE; 
		  m_bytesPerVoxel = 1; 
		  m_min = 0.f;
		  m_max = 255.f;

		  m_tileBytes = m_tileDim[0]*m_tileDim[1]*m_tileDim[2]*m_bytesPerVoxel;
	}	    
    return TRUE;
}

SbBool
CustomLDMReader::getMinMax(int & min, int & max)
{
  min=(int)m_min;
  max=(int)m_max;
  return TRUE;
}

SbBool
CustomLDMReader::getMinMax(double & min, double & max)
{
  min=m_min;
  max=m_max;
  return TRUE;
}

SbBool
CustomLDMReader::getMinMax(int64_t & min, int64_t & max)
{
  min=(int64_t)m_min;
  max=(int64_t)m_max;
  return TRUE;
}


SoVolumeReader::ReadError 
CustomLDMReader::getDataChar( SbBox3f &size, SoVolumeData::DataType &type, SbVec3i32 &dim )
{
  size=m_size;
  type=m_type;
  dim=m_dim;

  return RD_NO_ERROR;
}

SbBool
CustomLDMReader::getTileSize (SbVec3i32 &size)
{
  size = m_tileDim;
  return true;
}

SbBool
CustomLDMReader::getTileInfo(const int index , SbBox3i32& cellBox, int &resolution )
{
  if ( m_topo == NULL ) //create an LDMTopoOctree just to understand where each tile is in 3D space
  {
    m_topo = new SoLDMTopoOctree;
    m_topo->init( m_dim, m_tileDim[0] );
  }

  //given a tile index, retrieve a tileID, the bounding box and resolution
  SoLDMTileID tileID = m_topo->getTileID(index);
  cellBox = m_topo->getTilePos( tileID );
  resolution = m_topo->getLevelMax() - m_topo->level(tileID);

  return TRUE;
}

SoBufferObject*
CustomLDMReader::readTile(int index, const SbBox3i32& /*tilePosition*/ )
{
  SoCpuBufferObject* tileBuffer = new SoCpuBufferObject();
  tileBuffer->setSize(m_tileBytes);

  unsigned char* buffer = (unsigned char*)tileBuffer->map(SoBufferObject::SET);

  // get tile info
  SbBox3i32 cellBox; //actually this is already given in tilePosition
  int resolution;  //could be useful to know at which resolution we are
  if ( !getTileInfo(index, cellBox, resolution ) )
    return FALSE;


  //TO BE IMPLEMENTED
  // Fill the buffer according to information retrieved
  // such as inxed, cellBox and resolution
  // for example put a value depending only from resolution
  // actually here should access the file

  memset(buffer, resolution*256/4, m_tileBytes );
  tileBuffer->unmap();

  return tileBuffer;
}

void CustomLDMReader::getSubSlice( const SbBox2i32& , int , void * )
{
  fprintf(stderr,"CustomLDMReader::getSubSlice : Not Implemented\n");
  return;
}

SbBool
CustomLDMReader::isThreadSafe()
{
  return SbBool(TRUE);
}


