/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2020 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : David BEILLOIN (Dec 2008)
**=======================================================================*/


#ifndef _MY_LDM_READER_H
#define _MY_LDM_READER_H

#include <Inventor/SbLinear.h>
#include <Inventor/STL/map>
#include <Inventor/STL/list>

#include <Inventor/nodes/SoNode.h>
#include <Inventor/fields/SoSubField.h>

#include <Inventor/fields/SoSFNode.h>
#include <Inventor/fields/SoSFInt32.h>
#include <Inventor/fields/SoSFUInt32.h>
#include <Inventor/fields/SoSFEnum.h>
#include <Inventor/fields/SoSFFilePathString.h>
#include <Inventor/threads/SbThread.h>
#include <Inventor/threads/SbThreadMutex.h>
#include <VolumeViz/nodes/SoVolumeData.h>
#include <VolumeViz/readers/SoVolumeReader.h>

// When building the node as a DLL under Win32 we must explicitly
// declare this entry point as visible outside the DLL.
// The macro BUILDING_DLL is defined in the node's source file.
#ifdef BUILDING_DLL
  #define DLL_EXPORT VC_DLL_EXPORT
#else
  #define DLL_EXPORT VC_DLL_IMPORT
#endif

#ifdef _MSC_VER
#pragma warning( push )
#pragma warning(disable:4251)
#endif

class SoLDMTopoOctree;
class SoBufferObject;

/**
 * Custom LDM reader example.
 */
class DLL_EXPORT CustomLDMReader : public SoVolumeReader
{
  SO_FIELDCONTAINER_HEADER(CustomLDMReader);

public:

  /** Default Constructor. */
  CustomLDMReader();

  /** set use file name */
  virtual int setFilename(const SbString& filename);

  /** Standard reader stuf redefine */
  virtual SoVolumeReader::ReadError getDataChar( SbBox3f &size, SoVolumeData::DataType &type, SbVec3i32 &dim );
  virtual SbBool getTileSize (SbVec3i32 &size);
  virtual SbBool getMinMax(int & min, int & max);
  virtual SbBool getMinMax(double & min, double & max);
  virtual SbBool getMinMax(int64_t & min, int64_t & max);
  virtual SoBufferObject* readTile(int index, const SbBox3i32& tilePosition);
  virtual void getSubSlice( const SbBox2i32& subSlice, int sliceNumber, void * data );
  virtual SbBool isThreadSafe();
  virtual SbBool isDataConverted() const { return TRUE; }

protected:
  /** Destructor */
  ~CustomLDMReader();

  /** return position from LDM index */
  SbBool getTileInfo(const int index , SbBox3i32& cellBox, int& resolution );

private:
  SoLDMTopoOctree* m_topo;

  SbBox3f m_size;
  SoVolumeData::DataType m_type;
  SbVec3i32 m_dim;
  SbVec3i32 m_tileDim;
  double m_min;
  double m_max;
  size_t m_tileBytes;

  FILE* m_fp; 
};

#ifdef _MSC_VER
#pragma warning( pop )
#endif

#endif /* _SO_DATA_ACCESS_READER_H */

