/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2020 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : Thibaut Andrieu (Aug 2011)
**=======================================================================*/

#if !defined  _SO_CUSTOM_LDM_WRITER_H_
#define  _SO_CUSTOM_LDM_WRITER_H_

#include <LDM/writers/SoVolumeWriter.h>
#include <LDM/converters/SoLDMWriter.h>
#include <Inventor/fields/SoSFUInt32.h>
#include <Inventor/fields/SoSFVec3i32.h>
#include <Inventor/fields/SoSFBool.h>
#include <Inventor/fields/SoSFDouble.h>
#include <Inventor/fields/SoSFVec2d.h>
#include <Inventor/fields/SoMFFloat.h>
#include <LDM/readers/SoVolumeReader.h>
#include <LDM/SoLDMTopoOctree.h>


/** 
 * This class is a simplified version of SoVRLdmFileWriter.
 * It write data in ldm format, but without computing low resolution
 * and with a limited error management (no recovery file, etc...)
 */
class SoCustomLdmWriter : public SoVolumeWriter
{
  SO_FIELDCONTAINER_HEADER( SoVolumeWriter );

public:

  /** Header Filename. Data file will be the same, with a ".dat" extension. */
  SoSFString headerFilename;

  /** Size of tile. */
  SoSFVec3i32 tileSize;

  /** Constructor */
  SoCustomLdmWriter();

  /** Initialize writer from current parameters. Created and allocated data file
   * on disk. This operation can be quite long with big dataset. */
  virtual SbBool initialize();

  /**
   * Close all opened files so someone else can access them for reading or writing.
   */
  virtual SbBool closeAllHandles();

  /** Re-open files that was closed by the #closeAllHandles() method. */
  virtual SbBool restoreAllHandles();

  /** Return TRUE, as ldm format is organized in tiles. */
  virtual SbBool isDataConverted() const;

  /** write tile to disk. */
  virtual SbBool writeTile( const SoLDMTileID& tileId, SoBufferObject* buffer );

  /** Finalize creation of files. */
  virtual SbBool finish();

protected:

  /** Destructor */
  virtual ~SoCustomLdmWriter();

  /** Just to forbid modification of field when writer was initialized */
  virtual void notify(SoNotList *);

private:

  /** data file. Cretaed in the initialize method and close in the finish method. */
  FILE* m_dataFile;

  /** Topo octree of volume. Initialized in the initialized method. */
  SoLDMTopoOctree* m_LDMTopo;

  /** Does the writer is initialized or not. return to false when finish is called. */
  bool m_isInitialized;

};

#endif // _SO_CUSTOM_LDM_WRITER_H_


