/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2020 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : Thibaut Andrieu (Apr 2011)
**=======================================================================*/

//header files
#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>

#include <LDM/writers/SoVRLdmFileWriter.h>
#include <VolumeViz/nodes/SoVolumeRendering.h>
#include <LDM/SoLDMTopoOctree.h>
#include <LDM/readers/SoVRLdmFileReader.h>
#include <Inventor/STL/sstream>
#include <Inventor/helpers/SbFileHelper.h>
#include "SoCustomLdmWriter.h"

#define DEFAULT_FILE "$OIVHOME/examples/data/VolumeViz/colt-float.ldm";
#define OUT_FILE "$OIVHOME/examples/source/VolumeViz/CustomWriter/CustomLdmWriter/out.ldm"


//------------------------------------------------------------------------------
int main(int argc, char **argv)
{
  // Create the window
  Widget myWindow = SoXt::init(argv[0]); 
  if (myWindow == NULL)
    exit(1);

  SbString inputFilename = DEFAULT_FILE;

  if ( argc == 2 )
    inputFilename = argv[1];

  std::cout << "Opening file: " << inputFilename << std::endl;
  std::cout << "Result in: " << OUT_FILE << std::endl;


  SbString outputFilename = OUT_FILE;

  // Initialize VolumeViz extension
  SoVolumeRendering::init();
  SoCustomLdmWriter::initClass();

  // the idea is to use a reader and a writer that have the same parameters, read the volume and write it.

  SoVRLdmFileReader ldmReader;
  ldmReader.setFilename(inputFilename);
  SbBox3f dataSize;
  SoDataSet::DataType dataType;
  SbVec3i32 dataDim;
  ldmReader.getDataChar(dataSize, dataType, dataDim);

  // initialize writer
  SoCustomLdmWriter* writer = new SoCustomLdmWriter;
  writer->ref();
  writer->headerFilename.setValue( outputFilename );
  writer->dimension.setValue(dataDim);
  writer->extent.setValue(dataSize);
  writer->dataType.setValue(dataType);
  SbVec3i32 tileSize;
  ldmReader.getTileSize(tileSize);
  writer->tileSize.setValue(tileSize);
  writer->initialize();

  // initalize topoOctree (to retrieve fileId corresponding to tileId)
  SoLDMTopoOctree topoOctree;
  topoOctree.init( writer->dimension.getValue(), writer->tileSize.getValue()[0], 0 );
  const int nbTileIds = (int)topoOctree.getNumTileIDs();

  // now, for each tile, read and write it back.
  for ( SoLDMTileID tileId = 0; tileId < nbTileIds; ++tileId )
  {
    int fileId = topoOctree.getFileID(tileId);

    if ( fileId != -1 )
    {
      SbBox3i32 tilePosition;
      SoBufferObject* buffer = ldmReader.readTile( fileId, tilePosition );
      buffer->ref();
      writer->writeTile( tileId, buffer );
      buffer->unref();
    }
  }

  writer->finish();
  writer->unref();

  std::cout << "done." << std::endl;

  SoCustomLdmWriter::exitClass();
  SoVolumeRendering::finish();
  SoXt::finish();

  return 0;
}


