#pragma once

#include <QItemSelectionModel>
#include <QMainWindow>
#include <qstandarditemmodel.h>

#include <VolumeViz/nodes/SoOrthoSlice.h>

#include <Inventor/Qt/viewers/SoQtPlaneViewer.h>

#include <VolumeViz/readers/SoVRDicomFileReader.h>

namespace Ui
{
class DicomViewer;
}

class DicomViewer : public QMainWindow
{
  Q_OBJECT

public:
  explicit DicomViewer( QWidget* parent = Q_NULLPTR );
  ~DicomViewer();

public slots:
  void openFile();
  void openDirectory();
  void changeActiveSlice(const QModelIndex& index , const QModelIndex &);
  void updateModel( size_t idx );
  void loadPath( const QString& path );

private:
  void init();

  Ui::DicomViewer* m_ui;
  SoRef<SoVRDicomFileReader> m_reader;
  SoRef<SoVolumeData> m_volumeData;
  SoRef<SoDataRange> m_dataRange;
  SoRef<SoOrthoSlice> m_slice;
  SoQtPlaneViewer* m_renderArea;

  QItemSelectionModel* m_sliceSelectionModel;

  QStandardItemModel* m_sliceModel;
  QStandardItemModel* m_infoModel;
};
