#include <QApplication>

#include <Inventor/Qt/SbQtHelper.h>
#include <Inventor/SoDB.h>
#include <VolumeViz/nodes/SoVolumeRendering.h>
#include <VolumeViz/readers/dicom/SoDicomTag.h>

#include "DicomViewer.h"

int
main( int /*argc*/, char** argv )
{
  SbQtHelper::addPlatformPluginsPath();

  QWidget* mainWindow = SoQt::init( argv[0] );
  SoVolumeRendering::init();

  DicomViewer* window = new DicomViewer( mainWindow );

  SoQt::show( window );
  SoQt::mainLoop();

  SoVolumeRendering::finish();
  SoQt::finish();

  return 0;
}
