#if !defined(OGL_WINDOW_H)
#define OGL_WINDOW_H

class OGLWindowImpl;

enum SimpleKeyCode
{
  KEY_LEFT,
  KEY_RIGHT,
  KEY_UP,
  KEY_DOWN,
  KEY_SPACE,
  KEY_J,
  KEY_P,
  KEY_I
};

typedef void (*DrawCB)(void);

typedef void (*KeyCB)(const SimpleKeyCode);

class OGLWindow
{
public:
  OGLWindow(int width, int height);

  ~OGLWindow();

  void render();

  void mainLoop();

  void setDrawCallback(DrawCB callback);
  
  void setKeyCallback(KeyCB callback);

  void bindContext();
  
  void unbindContext();

  void update();
private:

  OGLWindowImpl* m_impl;
};

#endif // OGL_WINDOW_H
