/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2024 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : David Beilloin (Mar 2011)
**=======================================================================*/

#ifndef _CUSTOM_ASYNC_BUFFER_OBJECT_H_
#define _CUSTOM_ASYNC_BUFFER_OBJECT_H_

#include "common.h"

#include <Inventor/devices/SoCpuBufferObject.h>
#include <LDM/tiles/SoBufferPropertiesInterface.h>
#include <LDM/tiles/SoBufferAsyncInterface.h>

class SoBufferAsyncNotifierInterface;
class CustomAsyncBufferCache;
class SoGLBufferObject;

class READER_DLLEXPORT CustomAsyncBufferObject : public SoCpuBufferObject, public SoBufferPropertiesInterface, public SoBufferAsyncInterface
{
public:
  /** Constructors */
  CustomAsyncBufferObject();
  CustomAsyncBufferObject(CustomAsyncBufferCache*, int tileID);

  /** Destructor */
  virtual ~CustomAsyncBufferObject();

  //
  // Re-Implements SoBufferAsyncInterface
  //
  /** @copydoc SoBufferAsyncInterface::isInMemory */
  bool isInMemory() override;

  /** @copydoc SoBufferAsyncInterface::requestRefetch */
  void requestRefetch(SoBufferAsyncNotifierInterface* LDMAsyncNotifier, const double weight) override;

  //
  // Re-Implements methods from SoCpuBufferObject
  //

  /** @copydoc SoCpuBufferObject::map() */
  void* map(AccessMode accessMode, size_t offset = 0, size_t count = SO_BUFFER_SIZE_ALL) override;

  /** @copydoc SoCpuBufferObject::unmap() */
  void unmap() override;

  //
  // Re-Implements methods from SoBufferObject
  //

  /** @copydoc SoBufferObject::map() */
  void map( SoBufferObject* targetBufferObject, AccessMode accessMode, size_t startPosition = 0, size_t mappingSize = SO_BUFFER_SIZE_ALL) override;

  /** @copydoc SoBufferObject::map() */
  virtual void map( SoCpuBufferObject* targetBufferObject, AccessMode accessMode, size_t startPosition = 0, size_t mappingSize = SO_BUFFER_SIZE_ALL);
  
  /** @copydoc SoBufferObject::map() */
  virtual void map( SoGLBufferObject* targetBufferObject, AccessMode accessMode, size_t startPosition = 0, size_t mappingSize = SO_BUFFER_SIZE_ALL);

  /** @copydoc SoBufferObject::unmap() */
  virtual void unmap( SoCpuBufferObject* bufferObject );

  /** @copydoc SoBufferObject::unmap() */
  virtual void unmap( SoGLBufferObject* bufferObject );

  /** @copydoc SoBufferObject::unmap() */
  void unmap( SoBufferObject* bufferObject ) override;


  /** @copydoc SoBufferObject::setSize() */
  bool setSize( size_t size ) override;

  //
  // Implements SoBufferPropertiesInterface
  //
  /** @copydoc SoBufferPropertiesInterface::getMinMax */
  bool getMinMax(double& min, double& max) override;

  /** @copydoc SoBufferPropertiesInterface::getRealSize */
  size_t getRealSize() const override;


private:

  void setupBuffer();
  void resetBuffer();

  CustomAsyncBufferCache* m_customCache;
  int m_tileID;
  long m_useCount;
};

#endif //_CUSTOM_ASYNC_BUFFER_OBJECT_H_

