/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2020 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : David Beilloin (Mar 2011)
**=======================================================================*/

#include "CustomAsyncDataReader.h"
#include "CustomAsyncBufferObject.h"

#include <Inventor/errors/SoDebugError.h>


SO_FIELDCONTAINER_SOURCE(CustomAsyncDataReader);

////////////////////////////////////////////////////////////////////////
CustomAsyncDataReader::CustomAsyncDataReader()
{
  SO_FIELDCONTAINER_CONSTRUCTOR(CustomAsyncDataReader);
  m_customCache = NULL;
}

CustomAsyncDataReader::~CustomAsyncDataReader()
{
  delete m_customCache;
}

////////////////////////////////////////////////////////////////////////
void
CustomAsyncDataReader::initClass()
{
  SO_FIELDCONTAINER_INIT_CLASS(CustomAsyncDataReader, "CustomAsyncDataReader", SoVolumeReader);
}


////////////////////////////////////////////////////////////////////////
void
CustomAsyncDataReader::exitClass()
{
  SO__FIELDCONTAINER_EXIT_CLASS(CustomAsyncDataReader);
}


bool
CustomAsyncDataReader::initCache()
{
  if ( m_customCache ) 
    return true;

  fprintf(stdout,"Filename is %s\n",getFilename().toLatin1());

  // default parameters for testing purpose
  //m_customCache = new CustomAsyncBufferCache(SbVec3i32(1024,1024,1024),SbVec3i32(64,64,64),SoDataSet::UNSIGNED_BYTE,50);
  m_customCache = new CustomAsyncBufferCache(getFilename(), 50);

  return true;
}


/** returns the tile size to use for this reader */
SbBool
CustomAsyncDataReader::getTileSize(SbVec3i32& tile)
{
  initCache();

  tile = m_customCache->getTileDimension();
  return TRUE;
}

SbBool 
CustomAsyncDataReader::getMinMax(int64_t & min, int64_t & max)
{
  return m_customCache->getMinMax(min, max);
}

SbBool 
CustomAsyncDataReader::getMinMax(double & min, double & max)
{
  return m_customCache->getMinMax(min, max);
}

////////////////////////////////////////////////////////////////////////
SoVolumeReader::ReadError
CustomAsyncDataReader::getDataChar( SbBox3f &size, SoVolumeData::DataType &type,  SbVec3i32 &dim )
{
  initCache();

  // default value for testing purpose
  size= SbBox3f(-1, -1, -1, 1, 1, 1);
  dim = m_customCache->getDimension();
  type= m_customCache->getDataType();

  return RD_NO_ERROR;
}

////////////////////////////////////////////////////////////////////////
SoBufferObject* 
CustomAsyncDataReader::readTile(int index, const SbBox3i32& tilePosition)
{
  initCache();
  return m_customCache->createRequest(index, tilePosition);
}


