/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2020 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : David Beilloin (Mar 2011)
**=======================================================================*/
#ifndef  _CUSTOM_ASYNC_DATA_READER_H_
#define  _CUSTOM_ASYNC_DATA_READER_H_

#include "common.h"
#include "CustomAsyncBufferCache.h"

#include <VolumeViz/readers/SoVolumeReader.h>
#include <VolumeViz/nodes/SoVolumeData.h>

class CustomAsyncBufferCache;

#if defined(_WIN32) && !defined(BUILDING_DLL)
#pragma comment(lib,"CustomAsyncDataReader.LIB")
#endif

class READER_DLLEXPORT CustomAsyncDataReader : public SoVolumeReader
{
  SO_FIELDCONTAINER_HEADER(CustomAsyncDataReader);

public:
  //
  // redefined from SoVolumeReader
  //

  /** Constructor */
  CustomAsyncDataReader();

  /** @copydoc SoVolumeReader::isDataConverted */
  virtual SbBool isDataConverted() const
  { return TRUE; }

  /** @copydoc SoVolumeReader::isThreadSafe */
  virtual SbBool isThreadSafe() const
  { return TRUE; }

  /** @copydoc SoVolumeReader::getTileSize */
  virtual SbBool getTileSize(SbVec3i32& tile);

  /** @copydoc SoVolumeReader::getDataChar */
  virtual ReadError getDataChar( SbBox3f &size, SoVolumeData::DataType &type,  SbVec3i32 &dim );

  /** @copydoc SoVolumeReader::readTile */
  virtual SoBufferObject* readTile(int index, const SbBox3i32& tilePosition);

  /** @copydoc SoVolumeReader::getMinMax */
  virtual SbBool getMinMax(int64_t & min, int64_t & max);

  /** @copydoc SoVolumeReader::getMinMax */
  virtual SbBool getMinMax(double & min, double & max);

  //////////////////////////////////////////////////////////////////////////////////////////

  /** @copydoc SoVolumeReader::getSubSlice */
  void getSubSlice( const SbBox2i32& , int , void *)
  { assert(0); /* sanity check */ }

protected:
  /** Destructor */
  virtual ~CustomAsyncDataReader();

private:
  bool initCache();
  CustomAsyncBufferCache* m_customCache;
};

#endif // _CUSTOM_ASYNC_DATA_READER_H_


