/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2017 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (Apr 2003)
**=======================================================================*/

/*
 * Allows converting a volume data file to an octree topology based for VolumeViz 5.
 *
 * Parameters:
 * - source volume filename
 * - tile dimension (power of 2). Default is 64x64x64.
 * - destination filename. Default is the source filename with extension .ldm.
 * - amount of main memory to do not exceed. Default is 128 Mb.
 * - option to indicate to output the xml header only.
 *
 * Execute this program without any parameters to show up the full help text.
 *
 *============================================================================*/

#include <LDM/converters/SoLDMWriter.h>
#include <VolumeViz/nodes/SoVolumeData.h>
#include <LDM/converters/SoConverterParameters.h>

#define WRITE_SUB_VOLUME 0
#define WRITE_TILE 1

void
myXmlCB( FILE* /*f*/, void* /*data*/ )
{
  printf( "myXmlCB\n" );
}

int
main(int /*argc*/, char ** /*argv*/)
{
  SoDB::init();
  SoVolumeRendering::init();
  SoLDMWriter myLDMWriter;

  SbBox3f   size( 0,0,0, 1,1,2 );
  SbVec3i32 dimension( 128, 128, 128 );
  SoConverterParameters writerParams;
  writerParams.setTileDim(SbVec3i32(64, 64, 64));

  myLDMWriter.initialize( SbString("myldmfile.ldm"), size, dimension, SoVolumeData::UNSIGNED_BYTE, &writerParams );

  myLDMWriter.setXmlCallback( myXmlCB, NULL );

#ifdef WRITE_SUB_VOLUME
  const size_t volDim = 10;
  size_t bufferSize = volDim*volDim*volDim;
  unsigned char buffer[volDim][volDim][volDim];

  for (size_t k = 0; k < volDim; ++k)
    for (size_t j = 0; j < volDim; ++j)
      for (size_t i = 0; i < volDim; ++i)
        buffer[k][j][i] = ((i^j^k)&1) ? 0xff : 0x00;

  SoRef<SoCpuBufferObject> subVolumeBuffer = new SoCpuBufferObject;
  subVolumeBuffer->ref();
  subVolumeBuffer->setBuffer(buffer, bufferSize);

  SbBox3i32 subVolume;
  subVolume.setBounds( 10,10,10, 19,19,19 );
  myLDMWriter.writeSubVolume( subVolume, subVolumeBuffer.ptr() );

  subVolume.setBounds( 110,110,110, 119,119,119 );
  myLDMWriter.writeSubVolume( subVolume, subVolumeBuffer.ptr() );

  subVolume.setBounds( 30,30,30, 39,39,39 );
  myLDMWriter.writeSubVolume( subVolume, subVolumeBuffer.ptr() );

  subVolume.setBounds( 60,60,60, 69,69,69 );
  myLDMWriter.writeSubVolume( subVolume, subVolumeBuffer.ptr() );

  myLDMWriter.finish();
  subVolumeBuffer->unref();
#endif
#ifdef WRITE_TILE
  SoRef<SoCpuBufferObject> tileDataBuffer = new SoCpuBufferObject;
  tileDataBuffer->ref();
  tileDataBuffer->setSize(64*64*64);
  for (int t = 0; t < 8; ++t)
  {
    int value = t*35;
    tileDataBuffer->memset(&value);
    int i = (t&1) ? 66 : 0;
    int j = (t&2) ? 66 : 0;
    int k = (t&4) ? 66 : 0;
    myLDMWriter.writeTile( SbVec3i32(i,j,k), tileDataBuffer.ptr() );
  }
  tileDataBuffer->unref();
  myLDMWriter.finish();
#endif

  SoVolumeRendering::finish();
  SoDB::finish();
  return 0;
}


