/*----------------------------------------------------------------------------------------
LargeSliceSupport
Purpose : Show utility of LargeSliceSupport with volume skin node
author : Ludovic Peine
December 2009
----------------------------------------------------------------------------------------*/

#ifdef _MSC_VER
#pragma warning( disable : 4005 )
#endif

#include <DialogViz/SoDialogVizAll.h>

#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>
#include <Inventor/events/SoKeyboardEvent.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoTransform.h>
#include <Inventor/SbElapsedTime.h>
#include <Inventor/nodes/SoEventCallback.h>
#include <Inventor/nodes/SoTranslation.h>
#include <Inventor/nodes/SoBaseColor.h>
#include <Inventor/helpers/SbFileHelper.h>
#include <Inventor/nodes/SoFont.h>
#include <Inventor/nodes/SoText2.h>

#include <VolumeViz/nodes/SoVolumeData.h>
#include <VolumeViz/nodes/SoTransferFunction.h>
#include <VolumeViz/nodes/SoVolumeSkin.h> 

#include <LDM/manips/SoROIManip.h>

#include "utils.h"


//Define Default file name
SbString DefaultFileName = SbFileHelper::expandString("$OIVHOME/examples/data/VolumeViz/3DHEAD.ldm");

SbDataType dataType;


SoVolumeData* pVolData    = NULL;
SoVolumeSkin* pVolumeSkin = NULL;
SoROIManip*   pROIManip   = NULL;
SoText2*      menu        = NULL;

void
EventCB (void *, SoEventCallback *eventCB)
{
  const SoEvent *event = eventCB->getEvent();

  // Invert the LargeSliceSupport value
  if (SO_KEY_PRESS_EVENT(event, L)) 
  {
    bool largeSliceSupport = pVolumeSkin->largeSliceSupport.getValue();
    pVolumeSkin->largeSliceSupport.setValue(!largeSliceSupport);
  }
}

///////////////////////////////////////////////////////////////////////
// Set VolumeViz parameters from config file
// (using VolRend keywords for convenience)
//
void initVolVizParams( SoVolumeData * volData )
{
  SoLDMGlobalResourceParameters::setScreenResolutionCulling( 0 );
  SoLDMGlobalResourceParameters::setViewCulling( 0 );
  SoLDMGlobalResourceParameters::setViewpointRefinement( 0);
  SoLDMGlobalResourceParameters::setSliceEqualResolution( 1 );

  volData->ldmResourceParameters.getValue()->maxMainMemory = 1 ;
}

/**
* Simply reset the ROI to match the whole volume
*/
void resetRoi()
{
  pROIManip->box.setValue( SbVec3i32(0,0,0), pVolData->data.getSize() - SbVec3i32(1,1,1) );
  pROIManip->subVolume.setValue( SbVec3i32(0,0,0), pVolData->data.getSize()- SbVec3i32(1,1,1) );
  pROIManip->constrained = TRUE;
  pROIManip->boxOn = FALSE;
}

//////////////////////////////////////////////////////////////////////// 
int main(int argc, char **argv)
{
  char* filename = NULL;
  // Create the window
  Widget myWindow = SoXt::init(argv[0]);
  if (!myWindow)
    return 0;
  // Initialize DialogViz
  SoDialogViz::init();
  // Initialize VolumeViz
  SoVolumeRendering::init();

  SoTopLevelDialog *myTopLevelDialog;
  SbString InterfaceName = SbFileHelper::expandString("$OIVHOME/examples/source/VolumeViz/LargeSliceSupport/interface.iv");
  Widget parent = buildInterface(myWindow, InterfaceName.toLatin1(), "Viewer", &myTopLevelDialog);

  if ( argc < 2 )
    
    filename = (char*)DefaultFileName.toLatin1();
  else
    filename = (char*)SbFileHelper::expandString(argv[1]).toLatin1();

  pVolData = new SoVolumeData();
  initVolVizParams( pVolData );
  pVolData->fileName = filename;
  pVolumeSkin = new SoVolumeSkin;

  SbBox3f volExtent = pVolData->extent.getValue();

  // Use predefined colorMap with SoTransferFunction
  SoTransferFunction* pTransFunc = new SoTransferFunction();
  pTransFunc->predefColorMap = SoTransferFunction::PHYSICS;

  // Track the keyboard events
  SoEventCallback *eventCB = new SoEventCallback;
  eventCB->addEventCallback( SoKeyboardEvent::getClassTypeId(), EventCB, NULL );

  // Add a ROI
  pROIManip = new SoROIManip();
  resetRoi();

  // Assemble the scene graph
  // Note: SoVolumeSkin must appear after the SoVolumeData node.
  SoSeparator *root = new SoSeparator;
  root->ref();
  root->addChild( eventCB );
  root->addChild( pVolData );
  root->addChild( pROIManip );
  root->addChild( pTransFunc );
  root->addChild( pVolumeSkin );

  // Set up viewer:
  SoXtExaminerViewer *m_viewer = new SoXtExaminerViewer(parent);
  m_viewer->setSceneGraph(root);

  m_viewer->show();

  SoXt::show(myWindow);
  SoXt::mainLoop();
  delete m_viewer;
  root->unref();

  SoVolumeRendering::finish();
  SoDialogViz::finish();
  SoXt::finish();

  return 0;
}
  


