/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2017 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : G. SEGUIN (Oct 2001)
**=======================================================================*/

/////////////////////////////////////////////////////////////////////////////////
//
//Demo for realtime volume machining using VolumeRendering in Open Inventor
//
// Requires VolumeRendering library v3.0 or better
//
//
// Permission is granted for licensed customers of the 
// VolumeRendering library to use this source for any reasonable
// purpose that involves the VolumeRendering library.
//
// Files details:
//    - Machining.cxx/Machining.h: files containing VolumeRendering and Inventor machining code.
//    - SoVRBrush.cxx/SoVRBrush.h: utility class to help machining volumes.
//    - Controls.cxx/Controls.h: dialog box.
//
// If you want to enable/disable MPEG support you can define/undefine
// USE_MPEG in the project settings/Makefile.
//
/////////////////////////////////////////////////////////////////////////////////
#ifndef _MACHINING_
#define _MACHINING_

#include <stdio.h>

#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>
#include <Inventor/Xt/SoXt.h>
#include <Inventor/SoInput.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoLineSet.h>
#include <Inventor/nodes/SoMaterial.h>
#include <Inventor/nodes/SoCamera.h>
#include <Inventor/threads/SbThread.h>
#include <Inventor/sensors/SoTimerSensor.h>
#include <VolumeViz/nodes/SoVolumeData.h>
#include <VolumeViz/nodes/SoVolumeRenderingQuality.h>
#include <VolumeViz/nodes/SoVolumeRender.h>
#include <LDM/nodes/SoTransferFunction.h>
#include <Inventor/lock/SoLockMgr.h>
#include <Inventor/actions/SoSearchAction.h>
#include <Inventor/SoLists.h>

#ifdef USE_MPEG
#include <Inventor/MPEG/SoMPEGFrameRenderer.h>
#endif /* USE_MPEG */

#include "SoVRBrush.h"

// Data block dimensions
unsigned int m_xDim = 1024;
unsigned int m_yDim = 256;
unsigned int m_zDim = 32;

// Offsets of figure
unsigned int m_xOffset = 20;
unsigned int m_yOffset = 20;
unsigned int m_zOffset = 0;

// Brush used
SoVRBrush m_brush;

// Timer
SoTimerSensor * m_timer;

// Data
unsigned char * m_data = NULL;
SoVolumeData * m_dataNode = NULL;

// Shape drawing
int m_curPoint = -1;
int m_curChild = -1;
int m_counter = -1;
int m_maxCounter = 0;
int m_numPoints = 0;

// Brush
SoVRBrush::PredefinedMatrix m_brushType = SoVRBrush::CYLINDER;

// Colormap
SoTransferFunction * m_transferFunction;



// Render
SoVolumeRenderingQuality* m_renderQuality;
SoVolumeRender * m_render;

// Geometry information
SbVec3f m_scale;
SbVec3f m_shapeSize;
SbVec3s m_start;
SoPathList* m_lineSets;
SoGroup * m_workPath = NULL;

// Screen drawing speed
unsigned int m_drawingSpeed = 5;

// Texture file
const char * m_textureFileName = NULL;
FILE * m_textureFile = NULL;
// Texture colormap
SoMFFloat* m_colorMap = 0;
// Subsampling
SbVec3i32 m_subSampling = SbVec3i32(2,2,2);

// Shape file
const char * m_shapeFileName = NULL;
FILE * m_shapeFile = NULL;

#ifdef USE_MPEG
// MPEG render to create videos
SoMPEGFrameRenderer * m_MPEGRenderer = NULL;
// MPEG file name
char * m_MPEGFileName = NULL;
// Recording control variable
SbBool m_recording = FALSE;
#endif /* USE_MPEG */

// Method to restart the drawing of the shape
void restartDrawing(void);

// Method to change the brush
void setBrush(SbVec3s brushSize, SoVRBrush::PredefinedMatrix predefMatrix, unsigned char * matrix);

#endif /* _MACHINING_ */


