/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2017 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : Thierry Dufour (Jan 2003)
**=======================================================================*/
///////////////////////////////////////////////////////////////////////
//
//demo for VolumeRendering in Open Inventor
//
// Requires VolumeRendering library v1.1 or better
//
// Permission is granted for licensed customers of the 
// VolumeRendering library to use this source for any reasonable
// purpose that involves the VolumeRendering library.
//
// Please note this is a *demo* program, not an example program.
// It is intended to demonstrate some of the features of the 
// VolumeRendering library.  It is not necessarily an example of
// good programming style. :-)
//
///////////////////////////////////////////////////////////////////////

#include "MachiningAuditor.h"
#include "SoVRBrush.h"

#include <VolumeViz/nodes/SoVolumeData.h>
#include <VolumeViz/nodes/SoVolumeRender.h>
#include <VolumeViz/nodes/SoVolumeRenderingQuality.h>
#include <Inventor/sensors/SoTimerSensor.h>
#include <DialogViz/dialog/SoDialogCheckBox.h>
#include <DialogViz/dialog/SoDialogComboBox.h>
#include <DialogViz/dialog/SoDialogIntegerSlider.h>
#include <DialogViz/dialog/SoDialogEditText.h>
#include <DialogViz/dialog/SoTopLevelDialog.h>

#include <Inventor/helpers/SbFileHelper.h>

extern SoTopLevelDialog *m_topLevelDialog;
extern SoVolumeData     *m_dataNode;
extern SoVolumeRenderingQuality   *m_renderQuality;
extern SoVolumeRender   *m_render;
extern SbVec3i32         m_subSampling;
extern SoTimerSensor    *m_timer;
extern unsigned int      m_drawingSpeed;
extern const char       *m_shapeFileName;
extern const char       *m_textureFileName;
extern const char       *m_defaultTextFiles[];
extern SoVRBrush::PredefinedMatrix m_brushType;

extern void restartDrawing();
extern void setBrush(SbVec3s, SoVRBrush::PredefinedMatrix, unsigned char *);

MachiningAuditor::MachiningAuditor()
{
  m_machining = FALSE;
  SbString MarbleFile = "Marble.t3d";
  strcpy(m_customFile,MarbleFile.toLatin1());
}

/*----------------------------- dialogCheckBox -----------------------------------------*/
void
MachiningAuditor::dialogCheckBox(SoDialogCheckBox* cpt)
{
  SbBool state = cpt->state.getValue();

  if (cpt->auditorID.getValue() == "textureCompression")
    m_dataNode->useCompressedTexture = state;

  else if (cpt->auditorID.getValue() == "palettedTextures")
    m_dataNode->usePalettedTexture = state;

  else if (cpt->auditorID.getValue() == "viewAlignedSlices") {
    m_render->samplingAlignment = state ? SoVolumeRender::VIEW_ALIGNED : SoVolumeRender::DATA_ALIGNED;
    SbVec3i32 dim = m_dataNode->data.getSize();
    dim[0] >>= m_subSampling[0];
    dim[1] >>= m_subSampling[1];
    dim[2] >>= m_subSampling[2];
    if (dim[0]<dim[1]) dim[0] = dim[1];
    if (dim[0]<dim[2]) dim[0] = dim[2];
    m_render->numSlices.setValue(dim[0]);
  }

  else if (cpt->auditorID.getValue() == "lighting")
    m_renderQuality->deferredLighting = state;

  else if (cpt->auditorID.getValue() == "state") {
    m_machining = state;
    if (m_machining)
      m_timer->schedule();
    else
      m_timer->unschedule();
  }

}


/*----------------------------- dialogComboBox -----------------------------------------*/
void MachiningAuditor::dialogComboBox(SoDialogComboBox* cpt)
{
  int selectedItem = cpt->selectedItem.getValue();

  if (cpt->auditorID.getValue() == "texture") {
    if (selectedItem < 2) {
      static const char * defaultTextFiles[2] = { "Wood.t3d", "Marble.t3d" };
      m_textureFileName = defaultTextFiles[selectedItem];
    }
    else
      m_textureFileName = m_customFile;
    SoDialogEditText *dialogEditText = (SoDialogEditText*)m_topLevelDialog->searchForAuditorId(SbString("filename"));
    dialogEditText->editText.setValue(m_textureFileName);
    restartDrawing();
  }

  else if (cpt->auditorID.getValue() == "shape") {
    static char shapeName[256];
  
    sprintf(shapeName, "workPath%i.iv", selectedItem+1);
    SbString shapeFileNameAuditor = shapeName;
    m_shapeFileName = (char*)shapeFileNameAuditor.toLatin1();
    restartDrawing();
    if (m_machining)
      m_timer->schedule();
  }

  else if (cpt->auditorID.getValue() == "brushShape") {
    m_brushType = (SoVRBrush::PredefinedMatrix)selectedItem;
    setBrush(SbVec3s(10,10,14), m_brushType, NULL);
  }

}

/*----------------------------- dialogIntegerSlider -----------------------------------------*/
void MachiningAuditor::dialogIntegerSlider(SoDialogIntegerSlider* cpt)
{
  int value = cpt->value.getValue();

  m_drawingSpeed = value;
}


/*----------------------------- dialogPushButton -----------------------------------------*/
void MachiningAuditor::dialogPushButton(SoDialogPushButton* /*cpt*/)
{
  restartDrawing();
  if (m_machining)
    m_timer->schedule();
}


/*----------------------------- dialogEditText -----------------------------------------*/
void MachiningAuditor::dialogEditText(SoDialogEditText* cpt)
{
  strcpy(m_customFile, cpt->editText.getValue().getString());
}


