/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2017 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : G. SEGUIN (Mar 2001)
**=======================================================================*/
/////////////////////////////////////////////////////////////////////////////////
// 
//Demo for realtime volume machining using VolumeRendering in Open Inventor
//
// Requires VolumeRendering library v3.0 or better
//
// Permission is granted for licensed customers of the 
// VolumeRendering library to use this source for any reasonable
// purpose that involves the VolumeRendering library.
//
// Files details:
//    - Machining.cxx/Machining.h: files containing VolumeRendering and Inventor machining code.
//    - SoVRBrush.cxx/SoVRBrush.h: utility class to help machining volumes.
//    - Controls.cxx/Controls.h: dialog box.
//
// If you want to enable/disable MPEG support you can define/undefine
// USE_MPEG in the project settings/Makefile.
//
/////////////////////////////////////////////////////////////////////////////////
#ifndef _SO_VR_BRUSH_
#define _SO_VR_BRUSH_

#include <Inventor/SbLinear.h>
#include <string.h>

class SoVRBrush {

public:

  // Valid values for the brush matrix
  enum BrushValue {
    Empty = 0,  // Empty brush texel: this texel will not be machined
    Simple = 1, // Simple brush texel: this  texel will be machined
    Xm = 2,     // XMin pixel: this pixel will be machined, taking into account that it
                // is on a minimal X border
    Ym = 4,
    Zm = 8,
    XM = 16,    // XMax and so on...
    YM = 32,
    ZM = 64
  };

  // Predefined brush matrices
  enum PredefinedMatrix {
    SQUARE,
    SPHERE,
    CONE,
    CYLINDER
  };

  SoVRBrush() { m_matrix = 0; };

  SoVRBrush(const SoVRBrush &oldBrush) { m_size = oldBrush.m_size;
                                         m_matrix = new unsigned char[m_size[0]*m_size[1]*m_size[2]];
                                         memcpy(m_matrix, oldBrush.m_matrix, m_size[0]*m_size[1]*m_size[2]); };

  ~SoVRBrush() { if (m_matrix) delete [] m_matrix; };

  // Paints the brush into data at position. dataDim contains the dimensions of the data. bytesPerVoxel should be self-explanatory.
  void paint(SbVec3s position, unsigned char * data, SbVec3s dataDim, unsigned int bytesPerVoxel);

  // Sets the brush matrix. Can either be a predefined matrix or a user-supplied one.
  // Be carefull: either way the matrix will be deleted upon brush change/instance deletion.
  void setMatrix(SbVec3s size, PredefinedMatrix predefMatrix = CYLINDER, unsigned char * matrix = NULL);

  // Retrieves the size of the brush.
  const SbVec3s& getSize(void) { return m_size; };

private:
  SbVec3s m_size;
  unsigned char * m_matrix;

  void createSquareMatrix(void);
  void createConeMatrix(void);
  void createSphereMatrix(void);
  void createCylinderMatrix(void);
};

#endif /* _SO_VR_BRUSH_ */


