/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2020 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : David BEILLOIN (Oct 2007)
**=======================================================================*/


#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoSwitch.h>
#include <Inventor/helpers/SbFileHelper.h>

#include <DialogViz/SoDialogVizAll.h>
#include <VolumeViz/nodes/SoVolumeRendering.h>

#include "slice.h"
#include "horizon.h"

///////////////////////////////////////////////////////////
// Users defined global parameters 
///////////////////////////////////////////////////////////

const SbString slicePath = SbFileHelper::expandString("$OIVHOME/examples/source/VolumeViz/SegY-2D/");
const SbString horizonPath = SbFileHelper::expandString("$OIVHOME/examples/source/VolumeViz/SegY-2D/");

// default filename
const SbString sliceA = slicePath + "lineA.sgy";
const SbString sliceB = slicePath + "lineB.sgy";
const SbString sliceC = slicePath + "lineC.sgy";
const SbString sliceD = slicePath + "lineD.sgy";
const SbString sliceE = slicePath + "lineE.sgy";

const SbString horizonFileName = horizonPath + "3DHorizons.xyz";
///////////////////////////////////////////////////////////


// forward class definition
class myAuditorClass;

// forward functions declaration
Widget buildInterface( Widget );

// global variables 
SoTopLevelDialog*   myTopLevelDialog = NULL;
const SbString GUI_FILENAME = horizonPath + "SegY-2D.iv";


int
main(int /*argc*/, char ** argv)
{
  Widget myWindow = SoXt::init(argv[0]);
  if (myWindow == NULL)
    exit(1);
  SoVolumeRendering::init();
  SoDialogViz::init();

  // create main separator 
  SoSeparator *root = new SoSeparator;
  root->ref();

  root->addChild(createSEGY2DSliceSceneGraph(sliceA));
  root->addChild(createSEGY2DSliceSceneGraph(sliceB));
  root->addChild(createSEGY2DSliceSceneGraph(sliceC));
  root->addChild(createSEGY2DSliceSceneGraph(sliceD));
  root->addChild(createSEGY2DSliceSceneGraph(sliceE));

  root->addChild(createHorizon(horizonFileName));

  // Create a simple user interface to select viewing mode.
  Widget parent = buildInterface( myWindow );

  // Set up viewer 1:
  SoXtExaminerViewer *myViewer = new SoXtExaminerViewer(parent);
  myViewer->setSceneGraph(root);
  myViewer->setTitle("SEG-Y 2D Viewer test");
  myViewer->viewAll();
  myViewer->show();
  
  SoXt::show(myWindow);
  SoXt::mainLoop();

  SoVolumeRendering::finish();
  SoDialogViz::finish();
  SoXt::finish();
  return 0;
}



// DialogViz auditor class

class myAuditorClass : public SoDialogAuditor
{
  void dialogRadioButtons     (SoDialogRadioButtons* cpt);
};

void
myAuditorClass::dialogRadioButtons(SoDialogRadioButtons* cpt)
{
  // Select displayed object
  if ( cpt->auditorID.getValue() == "display") 
    if (globalRep!=NULL && globalWiggleRep!=NULL)
    {
      int value = cpt->selectedItem.getValue();
      // None
      switch ( value )
      {
      case 0: globalRep->whichChild.setValue(0); break;
      case 1: globalRep->whichChild.setValue(1); globalWiggleRep->whichChild.setValue(0);break;
      case 2: globalRep->whichChild.setValue(1); globalWiggleRep->whichChild.setValue(1);break;
      case 3: globalRep->whichChild.setValue(1); globalWiggleRep->whichChild.setValue(-3);break;
      case 4: globalRep->whichChild.setValue(-3); globalWiggleRep->whichChild.setValue(-3);break;
      }
    }
}

// Build user interface with embedded viewer
Widget
buildInterface(Widget window)
{
  SoInput myInput;
  if (! myInput.openFile( GUI_FILENAME ))
    return NULL;

  SoGroup *myGroup = SoDB::readAll( &myInput );
  if (! myGroup)
    return NULL;

  myTopLevelDialog = (SoTopLevelDialog *)myGroup->getChild( 0 );

  myAuditorClass *myAuditor = new myAuditorClass;
  myTopLevelDialog->addAuditor(myAuditor);

  SoDialogCustom *customNode = (SoDialogCustom *)myTopLevelDialog->searchForAuditorId(SbString("Viewer"));

  myTopLevelDialog->buildDialog( window, customNode != NULL );
  myTopLevelDialog->show();

  return customNode ? customNode->getWidget() : window;
}


