/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2020 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : David BEILLOIN (Oct 2007)
**=======================================================================*/


#ifndef _SLICE_H_
#define _SLICE_H_

#include <Inventor/SbString.h>

class SoScale;
class SoSwitch;
class SoNode;

///////////////////////////////////////////////////////////
// Users defined global parameters 
///////////////////////////////////////////////////////////

// only take 1/reduce trace in account to reduce complexity.
const int reduce = (1<<0);
// emphasis the wave amplitude (should use segy dataset property).
const float signal_scale = 40.0f;
// scale z geometry (should use segy dataset property).
const float z_scale = 30.0f;



///////////////////////////////////////////////////////////
// static variables. 
///////////////////////////////////////////////////////////

// geometry scale factor
extern  SoScale *globalScale;

// switch between density and Wiggle representation
// using -3 allow to get both
extern  SoSwitch *globalRep;

// switch between simple wiggle and wiggle variable density representation
// using -3 allow to get both
extern  SoSwitch *globalWiggleRep;


///////////////////////////////////////////////////////////
// Forward functions declaration.
///////////////////////////////////////////////////////////
SoNode *createSEGY2DSliceSceneGraph(const SbString &filename);

#endif /* _SLICE_H_ */


