/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2020 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : Jerome Hummel (Nov 2009)
**=======================================================================*/

/*----------------------------------------------------------------------------------------
This tool allows editing the alpha values of a SoTransferFunction node.
An alpha curve is presented to the user.
Keys can be inserted by double clicking in the colormap.
Keys can be removed by right clicking on a key.
For now only RGBA colormaps are treated
----------------------------------------------------------------------------------------*/

#include <LDM/nodes/SoTransferFunction.h>
#include <QWidget>

#ifndef _CM_EDITOR__
#define _CM_EDITOR__

//Alpha key definition
class AlphaKey
{
public:
    AlphaKey():mX(0),mY(0),mAlpha(0.f){}
    virtual ~AlphaKey(){}

    int mX;
    int mY;
    float mAlpha;

    bool operator==(const AlphaKey t){
        return mX == t.mX && mY == t.mY && fabs(mAlpha - t.mAlpha) < 10E-5 ;
    }
};

//Editor class
class AlphaCurveEditor: public QWidget
{
    Q_OBJECT

public:
    AlphaCurveEditor(SoTransferFunction* tf,QWidget* parent = NULL);
    virtual QSize sizeHint ();

protected:
    SoTransferFunction* mTransferFunction;
    QVector<QColor> mColorList;
    QImage mColormapImage;
    QVector<AlphaKey*> mKeys;
    bool mMousePressed;
    AlphaKey* mPickedKey;
    AlphaKey* mLeftKey;
    AlphaKey* mRightKey;
    int mNumColors;
    int mNumComponents;

    //functions
    void createColormapImage();
    void computeAlphaKeys();
    AlphaKey* getPickedKey(int x, int y);
    void updatePickedKey(int x, int y);
    void checkKeyPosition(int x, int y);
    void updateAlphaValues();
    void addKey(int x, int y);
    void removeKey(int x, int y);

    //overloaded Qt functions
    virtual void paintEvent ( QPaintEvent * event );
    virtual void mouseDoubleClickEvent ( QMouseEvent * event );
    virtual void mouseMoveEvent ( QMouseEvent * event );
    virtual void mousePressEvent ( QMouseEvent * event );
    virtual void mouseReleaseEvent ( QMouseEvent * event );
};

#endif //_CM_EDITOR__


