#include <RandomReader.h>

SO_FIELDCONTAINER_SOURCE( RandomReader );

//------------------------------------------------------------------------------
void
RandomReader::initClass()
{
  SO_FIELDCONTAINER_INIT_CLASS( RandomReader, "RandomReader", SoVolumeReader );
}

//------------------------------------------------------------------------------
void
RandomReader::exitClass()
{
  SO__FIELDCONTAINER_EXIT_CLASS( RandomReader );
}

//------------------------------------------------------------------------------
RandomReader::RandomReader()
{
  SO_FIELDCONTAINER_CONSTRUCTOR( RandomReader );
}

//------------------------------------------------------------------------------
RandomReader::RandomReader( bool doUniform, const SbVec3i32& dim )
  : m_type( SoDataSet::UNSIGNED_BYTE )
  , m_dim( dim )
  , m_tileDim( 64, 64, 64 )
  , m_doUniform( doUniform )
{
  SO_FIELDCONTAINER_CONSTRUCTOR( RandomReader );
}

//------------------------------------------------------------------------------
SoVolumeReader::ReadError
RandomReader::getDataChar( SbBox3f& size, SoVolumeData::DataType& type, SbVec3i32& dim )
{
  size = SbBox3f( 0.f, 0.f, 0.f, ( float )m_dim[0], ( float )m_dim[1], ( float )m_dim[2] );
  type = m_type;
  dim = m_dim;

  m_tileBytes = m_tileDim[0] * m_tileDim[1] * m_tileDim[2];

  return RD_NO_ERROR;
}


//------------------------------------------------------------------------------
SbBool
RandomReader::getTileSize( SbVec3i32& size )
{
  size = m_tileDim;
  return TRUE;
}

//------------------------------------------------------------------------------
SbBool
RandomReader::isThreadSafe() const
{
  return TRUE;
}

//------------------------------------------------------------------------------
SbBool
RandomReader::isDataConverted() const
{
  return TRUE;
}

//------------------------------------------------------------------------------
SoBufferObject*
RandomReader::readTile( int /*fileID*/, const SbBox3i32& /*tilePosition*/ )
{
  SoCpuBufferObject* tileBuffer;
  const char voxelValue = ( unsigned char )( ( ( float )rand() / ( float )RAND_MAX ) * 255.0f );

  if ( m_doUniform )
  {
    tileBuffer = new SoCpuBufferUniform( voxelValue, SoDataSet::DataType::UNSIGNED_BYTE );
    tileBuffer->setSize( m_tileBytes );
  }
  else
  {
    tileBuffer = new SoCpuBufferObject;
    tileBuffer->setSize( m_tileBytes );
    unsigned char* buffer = ( unsigned char* )tileBuffer->map( SoBufferObject::SET );
    memset( buffer, voxelValue, m_tileBytes );
    tileBuffer->unmap();
  }

  return tileBuffer;
}

//------------------------------------------------------------------------------
void
RandomReader::getSubSlice( const SbBox2i32& /*subSlice*/, int sliceNumber, void* /*data*/ )
{
}

//------------------------------------------------------------------------------
SbVec2d
RandomReader::getTileMinMax( int /*fileId*/ ) const
{
  // Dummy values are returned only for the purpose of this demo
  if ( m_doUniform ) // LDM loads efficiently uniform tiles only if the min & max are equal
    return SbVec2d( 0, 0 );
  else
    return SbVec2d( -1, 1 );
}
