#pragma once
#include <VolumeViz/nodes/SoVolumeData.h>
#include <VolumeViz/readers/SoVolumeReader.h>

class SoBufferObject;

class RandomReader : public SoVolumeReader
{
  SO_FIELDCONTAINER_HEADER( RandomReader );

public:
  RandomReader();
  RandomReader( bool doUniform, const SbVec3i32& dim );

  virtual SoVolumeReader::ReadError getDataChar( SbBox3f& size, SoVolumeData::DataType& type, SbVec3i32& dim ) override;
  virtual SbBool getTileSize( SbVec3i32& size ) override;
  virtual SbVec2d getTileMinMax( int fileId ) const override;
  virtual SoBufferObject* readTile( int index, const SbBox3i32& tilePosition ) override;
  virtual void getSubSlice( const SbBox2i32& subSlice, int sliceNumber, void* data ) override;
  virtual SbBool isThreadSafe() const override;
  virtual SbBool isDataConverted() const override;

private:
  SbBox3f m_size;
  SoVolumeData::DataType m_type;
  SbVec3i32 m_dim;
  SbVec3i32 m_tileDim;
  bool m_doUniform;
  size_t m_tileBytes;
};
