//!oiv_include <VolumeViz/vvizfnc_frag.h>

uniform float threshold;

//!oiv_include <VolumeViz/vvizGetData_frag.h>
//!oiv_include <VolumeViz/vvizTransferFunction_frag.h>

uniform VVizDataSetId data1;
uniform VVizDataSetId data2;

vec4 VVizComputeFragmentColor(VVIZ_DATATYPE vox, vec3 texCoord)
{
  //texture unit 1 -> data 1
  VVIZ_DATATYPE index1 = VVizGetData(data1, texCoord);
  //Use transfer function 0
  vec4 data1Color = VVizTransferFunction(index1, 0);

  //texture unit 2 -> data 2
  VVIZ_DATATYPE index2 = VVizGetData(data2, texCoord);
  //Use transfer function 1
  vec4 data2Color = VVizTransferFunction(index2, 1);

#if 1
  vec4 res = data1Color*threshold + data2Color*(1.-threshold);
#else
  // Color modulated by intensity from volume2
  data2Color.rgb *= data1Color.r;
  data2Color.a   *= data1Color.a;
#endif
  return res;
}


vec4 VVizComputeVVizDataDrawStyle1(in vec3 rayDir, inout VVizVoxelInfo voxelInfoFront, in VVizVoxelInfo voxelInfoBack);
vec4 VVizComputeVVizDataDrawStyle2(in vec3 rayDir, inout VVizVoxelInfo voxelInfoFront, in VVizVoxelInfo voxelInfoBack);

vec4 VVizComputeFragmentColor(VVizDataSetId dataset, vec3 rayDir, inout VVizVoxelInfo voxelInfoFront, in VVizVoxelInfo voxelInfoBack, int mask)
{
  // Get standard VolumeViz lighting of both dataset
  vec4 data1Color  = VVizComputeVVizDataDrawStyle1(rayDir, voxelInfoFront, voxelInfoBack);
  vec4 data2Color  = VVizComputeVVizDataDrawStyle2(rayDir, voxelInfoFront, voxelInfoBack);

#if 1
  // custom behavior based on threshold value
  vec4 res;
  res = data1Color*threshold + data2Color*(1.-threshold);
#else
  // Default volumeviz behavior
  vec4 res = vec4(0.);
  res = VVizOverOperator(res, data1Color);
  res = VVizOverOperator(res, data2Color);
#endif

  return res;
}

