/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2020 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : David Beilloin (Apr 2011)
**=======================================================================*/

#include "utils.h"
#include "VVIZ-interface.h"


#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>
#include <Inventor/Xt/SoXtRenderArea.h>

// DialogViz Interface
#include <DialogViz/SoDialogVizAll.h>
#include <DialogViz/dialog/SoTopLevelDialog.h>

// Inventor nodes
#include <Inventor/nodes/SoSwitch.h>
// VolumeViz nodes
#include <LDM/SoLDMGlobalResourceParameters.h>
#include <VolumeViz/nodes/SoVolumeShader.h>


SoTopLevelDialog* g_myTopLevelDialog = NULL;

// DialogViz auditor class to handle user input
class myAuditorClass : public SoDialogAuditor
{
public:
  myAuditorClass(SoNode* globalSG)
    :SoDialogAuditor(),m_globalScenegraph(globalSG),m_curManipSwitch(NULL)
  {}
protected:
  virtual void dialogCheckBox (SoDialogCheckBox* cpt);
  virtual void dialogIntegerSlider(SoDialogIntegerSlider* cpt);
  virtual void dialogComboBox(SoDialogComboBox* cpt);

private:
  SoNode*   m_globalScenegraph;
  SoSwitch* m_curManipSwitch;
};

// Auditor method for checkBox input
void
myAuditorClass::dialogCheckBox(SoDialogCheckBox* cpt)
{
  if (cpt->auditorID.getValue() == "ShowTopology")
  {
    SbBool value = cpt->state.getValue();
    SoLDMGlobalResourceParameters::setVisualFeedbackParam(SoLDMGlobalResourceParameters::DRAW_TOPOLOGY, value);
  }
  else if (cpt->auditorID.getValue() == "ShowTopologyGPU")
  {
    SbBool value = cpt->state.getValue();
    SoLDMGlobalResourceParameters::setVisualFeedbackParam(SoLDMGlobalResourceParameters::DRAW_TILE_OUTLINE, value);
  }
}

// Auditor method for IntegerSlider input
void
myAuditorClass::dialogIntegerSlider(SoDialogIntegerSlider* cpt)
{
  // change current max 3D texture memory
  if (cpt->auditorID.getValue() == "gpuMemory")
    SoLDMGlobalResourceParameters::setMaxTexMemory(cpt->value.getValue());
  // change current max cpu memory
  else if (cpt->auditorID.getValue() == "cpuMemory")
    SoLDMGlobalResourceParameters::setMaxMainMemory(cpt->value.getValue());
}

// Auditor method for comboBox input
void
myAuditorClass::dialogComboBox(SoDialogComboBox* cpt)
{
  // activate or not manipulator switch
  if (cpt->auditorID.getValue() == "ManipulatorMode")
  {
    // first disable previous manipulator if any
    if ( m_curManipSwitch )
    {
      m_curManipSwitch->whichChild = -1;
      m_curManipSwitch = NULL;
    }

    // Then search for the new selected manipulator and activate it
    m_curManipSwitch = searchName<SoSwitch>(m_globalScenegraph, cpt->items.getValues(0)[cpt->selectedItem.getValue()]);

    // and activate it
    if ( m_curManipSwitch )
      m_curManipSwitch->whichChild = -3;

  }
  // rendering
  if (cpt->auditorID.getValue() == "RenderMode")
  {
    SoSwitch* renderSwitch = searchName<SoSwitch>(m_globalScenegraph,"VolumeRenderingSwitch");
    SoSwitch* renderSwitch2 = searchName<SoSwitch>(m_globalScenegraph,"HorizonRenderingSwitch");

    const SbString* itemsArray = cpt->items.getValues(0);
    if ( itemsArray[cpt->selectedItem.getValue()].contains("ALL") )
    {
      renderSwitch->whichChild  = SO_SWITCH_ALL;
      renderSwitch2->whichChild = SO_SWITCH_ALL;
    }
    else
    {
      if ( cpt->items.getNum()-1 == cpt->selectedItem.getValue() )
      {
        renderSwitch->whichChild = -1;
        renderSwitch2->whichChild = 0;
      }
      else
      {
        renderSwitch->whichChild = cpt->selectedItem.getValue();
        renderSwitch2->whichChild = -1;
      }
    }
  }

  // Clipping
  if (cpt->auditorID.getValue() == "ClippingMode")
  {
    SoSwitch* clippingSwitch = searchName<SoSwitch>(m_globalScenegraph,"VolumeClippingSwitch");

    const SbString* itemsArray = cpt->items.getValues(0);
    if ( itemsArray[cpt->selectedItem.getValue()].contains("ALL") )
      clippingSwitch->whichChild  = SO_SWITCH_ALL;
    else
      clippingSwitch->whichChild = cpt->selectedItem.getValue();
  }
}

Widget
buildInterface(Widget window, const char* filename, const char* viewer, SoTopLevelDialog** myTopLevelDialog, SoNode* VVIZSceneGraph)
{
  *myTopLevelDialog = NULL;

  SoInput myInput;
  if (! myInput.openFile( filename ))
    return NULL;

  SoGroup *myGroup = SoDB::readAll( &myInput );
  if (! myGroup)
    return NULL;

  g_myTopLevelDialog = *myTopLevelDialog = (SoTopLevelDialog *)myGroup->getChild( 0 );

  SoDialogCustom *customNode = (SoDialogCustom *)(*myTopLevelDialog)->searchForAuditorId(SbString(viewer));

  // Create and register auditor to handle user input
  myAuditorClass *myAuditor = new myAuditorClass(VVIZSceneGraph);
  (*myTopLevelDialog)->addAuditor(myAuditor);

  (*myTopLevelDialog)->buildDialog( window, customNode != NULL );
  (*myTopLevelDialog)->show();

  // checkbox init with current interface file
  {
    SoDialogCheckBox* cpuTopology = (SoDialogCheckBox*)( (*myTopLevelDialog)->searchForAuditorId(SbString("ShowTopology")) );
    if ( cpuTopology )
      SoLDMGlobalResourceParameters::setVisualFeedbackParam(SoLDMGlobalResourceParameters::DRAW_TOPOLOGY,cpuTopology->state.getValue());

    SoDialogCheckBox* gpuTopology = (SoDialogCheckBox*)( (*myTopLevelDialog)->searchForAuditorId(SbString("ShowTopologyGPU")) );
    if ( cpuTopology )
      SoLDMGlobalResourceParameters::setVisualFeedbackParam(SoLDMGlobalResourceParameters::DRAW_TILE_OUTLINE,gpuTopology->state.getValue());
  }

  // Connect checkbox ForVolumeOnly to all SovolumeShader::forVolumeOnly field 
  {
    SoDialogCheckBox* forVolumeOnly = (SoDialogCheckBox*)( (*myTopLevelDialog)->searchForAuditorId(SbString("ForVolumeOnly")) );
    if (forVolumeOnly)
    {
      SoSearchAction* sa = new SoSearchAction;
      sa->setFind(SoSearchAction::TYPE);
      sa->setSearchingAll(true);
      sa->setInterest(SoSearchAction::ALL);
      sa->setType(SoVolumeShader::getClassTypeId());
      sa->apply(VVIZSceneGraph);

      SoPathList& pathList = sa->getPaths();
      for (int i=0;i<pathList.getLength();++i)
      {
        SoPath* path = pathList[i];
        SoVolumeShader* shader = dynamic_cast<SoVolumeShader*>(path->getTail());
        shader->forVolumeOnly.connectFrom(&forVolumeOnly->state);
      }
    }
  }
  // Connect checkbox interpolateOnMode to all SoVolumeShader::interpolateOnMove field 
  {
    SoDialogCheckBox* interpolateOnMove = (SoDialogCheckBox*)( (*myTopLevelDialog)->searchForAuditorId(SbString("interpolateOnMove")) );
    if (interpolateOnMove)
    {
      SoSearchAction* sa = new SoSearchAction;
      sa->setFind(SoSearchAction::TYPE);
      sa->setSearchingAll(true);
      sa->setInterest(SoSearchAction::ALL);
      sa->setType(SoVolumeShader::getClassTypeId());
      sa->apply(VVIZSceneGraph);

      SoPathList& pathList = sa->getPaths();
      for (int i=0;i<pathList.getLength();++i)
      {
        SoPath* path = pathList[i];
        SoVolumeShader* shader = dynamic_cast<SoVolumeShader*>(path->getTail());
        shader->interpolateOnMove.connectFrom(&interpolateOnMove->state);
      }
    }
  }

  // integerSlider init with current interface file
  {
    SoDialogIntegerSlider* cpuMemory = (SoDialogIntegerSlider*)( (*myTopLevelDialog)->searchForAuditorId(SbString("cpuMemory")) );
    if ( cpuMemory )
      SoLDMGlobalResourceParameters::setMaxMainMemory(cpuMemory->value.getValue());
    SoDialogIntegerSlider* gpuMemory = (SoDialogIntegerSlider*)( (*myTopLevelDialog)->searchForAuditorId(SbString("gpuMemory")) );
    if ( gpuMemory )
      SoLDMGlobalResourceParameters::setMaxTexMemory(gpuMemory->value.getValue());
  }

  // Combobox to select which object to show
  {
    SoDialogComboBox* renderModeCombo = (SoDialogComboBox*)( (*myTopLevelDialog)->searchForAuditorId(SbString("RenderMode")) );
    if ( renderModeCombo != NULL )
    {
      SoSwitch* renderSwitch = searchName<SoSwitch>(VVIZSceneGraph,"VolumeRenderingSwitch");
      SoSwitch* renderSwitch2 = searchName<SoSwitch>(VVIZSceneGraph,"HorizonRenderingSwitch");
      if ( renderSwitch && renderSwitch2 )
      {
        for ( int i = 0; i < renderSwitch->getNumChildren(); ++i)
        {
          SoNode* child = renderSwitch->getChild(i);
          renderModeCombo->items.set1Value(i, child->getName().getString());
        }
        for ( int i = 0; i < renderSwitch2->getNumChildren(); ++i)
        {
          SoNode* child = renderSwitch2->getChild(i);
          renderModeCombo->items.set1Value(renderSwitch->getNumChildren()+i,child->getName().getString());
        }
      }
      else
        renderModeCombo->enable = FALSE;
    }
  }

  // Combobox to select which clipping techniques to use
  {
    SoDialogComboBox* clippingModeCombo = (SoDialogComboBox*)( (*myTopLevelDialog)->searchForAuditorId(SbString("ClippingMode")) );
    if ( clippingModeCombo != NULL )
    {
      SoSwitch* clippingSwitch = searchName<SoSwitch>(VVIZSceneGraph,"VolumeClippingSwitch");
      if ( clippingSwitch )
      {
        for ( int i = 0; i < clippingSwitch->getNumChildren(); ++i)
        {
          SoNode* child = clippingSwitch->getChild(i);
          clippingModeCombo->items.set1Value(i, child->getName().getString());
        }
      }
      else
        clippingModeCombo->enable = FALSE;
    }
  }

  // Combobox to select which shader techniques to use
  {
    SoDialogComboBox* volumeShaderModeCombo = (SoDialogComboBox*)( (*myTopLevelDialog)->searchForAuditorId(SbString("ShaderMode")) );
    if ( volumeShaderModeCombo != NULL )
    {
      SoSwitch* volumeShaderSwitch = searchName<SoSwitch>(VVIZSceneGraph,"VolumeShaderSwitch");
      if ( volumeShaderSwitch )
      {
        for ( int i = 0; i < volumeShaderSwitch->getNumChildren(); ++i)
        {
          SoNode* child = volumeShaderSwitch->getChild(i);
          volumeShaderModeCombo->items.set1Value(i, child->getName().getString());
        }
        volumeShaderSwitch->whichChild.connectFrom( &volumeShaderModeCombo->selectedItem );
      }
      else
        volumeShaderModeCombo->enable = FALSE;
    }
  }

  // Combobox to select which manipulator to get as active
  {
    SoDialogComboBox* manipulatorModeCombo = (SoDialogComboBox*)( (*myTopLevelDialog)->searchForAuditorId(SbString("ManipulatorMode")) );
    if ( manipulatorModeCombo != NULL )
    {
      // Search for all switch named swopt in their name
      {
        SoSearchAction* sa = new SoSearchAction;
        sa->setFind(SoSearchAction::TYPE);
        sa->setSearchingAll(true);
        sa->setInterest(SoSearchAction::ALL);
        sa->setType(SoSwitch::getClassTypeId());
        sa->apply(VVIZSceneGraph);
        SoPathList& switchPathList = sa->getPaths();
        int numItemAdded=0;
        for (int i=0; i<switchPathList.getLength();++i)
        {
          SoPath* path = switchPathList[i];
          SoSwitch *curSwitch = dynamic_cast<SoSwitch*>(path->getTail());
          if ( curSwitch )
          {
            SbString curName = curSwitch->getName().getString();
            if ( curName.contains("swopt") )
              manipulatorModeCombo->items.set1Value(numItemAdded++,curName);
          }
        }
      }
    }
    else
      manipulatorModeCombo->enable = FALSE;
  }


  // connect all boolean field named enableBumpMapping to the enableBumpMapping checkBox
  // connect all integer field named bumpscale to the bumpSclae integerSlider
  {
    SoDialogCheckBox* enableBumpMapping = (SoDialogCheckBox*)( (*myTopLevelDialog)->searchForAuditorId(SbString("enableBumpMapping")) );
    SoDialogIntegerSlider* bumpScale = (SoDialogIntegerSlider*)( (*myTopLevelDialog)->searchForAuditorId(SbString("bumpScale")) );
    if (enableBumpMapping && bumpScale)
    {
      SoSearchAction* sa = new SoSearchAction;
      sa->setFind(SoSearchAction::TYPE);
      sa->setSearchingAll(true);
      sa->setInterest(SoSearchAction::ALL);
      sa->setType(SoSlice::getClassTypeId());
      sa->apply(VVIZSceneGraph);

      SoPathList& pathList = sa->getPaths();
      for (int i=0;i<pathList.getLength();++i)
      {
        SoPath* path = pathList[i];
        SoSlice* slice = dynamic_cast<SoSlice*>(path->getTail());
        slice->enableBumpMapping.connectFrom(&enableBumpMapping->state);
        slice->bumpScale.connectFrom(&bumpScale->value);
      }
    }
  }


  return customNode ? customNode->getWidget() : window;
}


