#pragma once
#include <Inventor/SoProgressIndicator.h>

class EventRaisedProgressBar
{
public:

  EventRaisedProgressBar() : m_numTilesLoaded(0), m_numTilesToLoad(0) {};

  void onProgressFunc(SoProgressIndicator::StepEventArg& eventArg)
  {
    if (eventArg.getEventName() == "Loading Texture")
    {
      m_numTilesLoaded += eventArg.getNumStepsDone();
      m_numTilesToLoad += eventArg.getNumSteps();
    }
  }

  void redrawProgressBar()
  {
    if (m_numTilesToLoad != 0)
    {
      const float ldmProgress = m_numTilesLoaded / float(m_numTilesToLoad);
      m_infoText->string.deleteValues(0);
      std::ostringstream buffer;
      buffer << "Tiles: " << m_numTilesLoaded << "/" << m_numTilesToLoad;

      m_vpProgressBar->vertex.set1Value(0, SbVec3f(0.f, -0.02f, 0));
      m_vpProgressBar->vertex.set1Value(1, SbVec3f(0.f, -0.05f, 0));
      m_vpProgressBar->vertex.set1Value(2, SbVec3f(0.4f * ldmProgress, -0.02f, 0));
      m_vpProgressBar->vertex.set1Value(3, SbVec3f(0.4f * ldmProgress, -0.02f, 0));
      m_vpProgressBar->vertex.set1Value(4, SbVec3f(0.f, -0.05f, 0));
      m_vpProgressBar->vertex.set1Value(5, SbVec3f(0.4f * ldmProgress, -0.05f, 0));

      m_infoText->string.set1Value(0, SbString(buffer.str().c_str()));
    }
    m_numTilesLoaded = 0;
    m_numTilesToLoad = 0;
  }

private:
  unsigned int m_numTilesLoaded;
  unsigned int m_numTilesToLoad;
};


