/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2020 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : Pascal Estrade (Jul 2009)
**=======================================================================*/

/*----------------------------------------------------------------------------------------
Medical example program.
Description : Manage events for this demonstration.
----------------------------------------------------------------------------------------*/
#include "manageEvents.h"

static SbBool leftMousePressed = FALSE;


void
mouseMoveEventCB(void *userData, SoEventCallback *eventCB)
{
	const SoEvent *event = eventCB->getEvent();
	SbVec2s myVec2s = event->getPosition();
	SoDataRange *localDataRange = (SoDataRange*)userData;

	static int horizVal;
	static int vertiVal;

	if( ::leftMousePressed ) {
		
		double minVal = localDataRange->min.getValue(); 
		if(  myVec2s[0] > horizVal ) {
			minVal += 20;
		} 
		if( myVec2s[0] < horizVal ) {
			minVal -= 20;
		}
		localDataRange->min.setValue(minVal);
		horizVal = myVec2s[0];

		double maxVal = localDataRange->max.getValue(); 
		if(  myVec2s[1] > vertiVal ) {
			maxVal += 10;
		} 
		if( myVec2s[1] < vertiVal ) {
			maxVal -= 10;
		}
		localDataRange->max.setValue(maxVal);
		vertiVal = myVec2s[1];
	}

}
void
mouseKeyEventCB(void* /*userData*/, SoEventCallback *eventCB)
{
	const SoEvent *event = eventCB->getEvent();

	// Check for mouse button being pressed
	if (SO_MOUSE_PRESS_EVENT(event, BUTTON1)) {
		::leftMousePressed = TRUE;
		eventCB->setHandled();
	} else {
		::leftMousePressed = FALSE;
	}
}


