/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2020 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (Apr 2003)
**=======================================================================*/
/*==============================================================================
 *
 * Allows converting a volume data file to an LDM format file for VolumeViz
 *
 * Parameters: 
 * - source volume filename
 * - tile dimension (power of 2). Default is 64x64x64.
 * - destination filename. Default is the source filename with extension .ldm.
 * - amount of main memory to do not exceed. Default is 512 Mb.
 * - option to indicate to output the xml header only.
 *
 * Execute this program without any parameters to show the full help text.
 * Also see the help pages for SoConverter.
 *
 *============================================================================*/

#include <VolumeViz/nodes/SoVolumeRendering.h>
#include <VolumeViz/converters/SoVolumeConverter.h>
#include <LDM/converters/SoConverterParameters.h>

int
main(int argc, char ** argv)
{
  SoVolumeRendering::init();

  int ret = 1;
  {
    SoVolumeConverter myConverter;
    SoConverterParameters* myConverterParameters = SoConverterParameters::create(argc,argv);

    ret = myConverter.convert( myConverterParameters );

    delete myConverterParameters;
  }
  SoVolumeRendering::finish();
  return ret;
}


