#include "SoCustomDataCompressor.h"

#include <Inventor/STL/iostream>

SO_TYPED_CLASS_SOURCE(SoDataCompressor, SoCustomDataCompressor, "CustomDataCompressor");

SoCustomDataCompressor:: SoCustomDataCompressor ()
{ 
  setCompressionLevel(3); //set the default compression level
}

size_t
SoCustomDataCompressor::compress(void *src, size_t srcLen, const TileInfo &/*tileInfo*/)
{
  //Compression is just identity here
  std::cout << "Compressing at level " << getCompressionLevel() << std::endl;
  allocateCompressedBuffer(computeNeededSpace(srcLen)) ;

  size_t compressedSize = myCompressionAlgo(m_compressedBuffer, src, srcLen) ;

  return compressedSize;
}

size_t
SoCustomDataCompressor::uncompress(void *dest, size_t destLen, const TileInfo &/*tileInfo*/)
{
  std::cout << "Uncompressing with SoCustomDataCompressor" << std::endl;
  myDecompressionAlgo(dest, destLen, m_compressedBuffer) ;

  return destLen;
}

size_t
SoCustomDataCompressor::computeNeededSpace(size_t len)
{
  return len;
}

size_t
SoCustomDataCompressor::myCompressionAlgo( std::vector<unsigned char>& dest, void *src, size_t srcLen)
{
  unsigned char* dataSource = (unsigned char*)src;
  memcpy(&dest[0], dataSource, srcLen);
  return srcLen;
}

void
SoCustomDataCompressor::myDecompressionAlgo(void* dest, size_t /*destLen*/, std::vector<unsigned char>& compressedData)
{
  memcpy(dest, &compressedData[0], compressedData.size());
}


