#include <LDM/compressors/SoDataCompressor.h>
class SoCustomDataCompressor : public SoDataCompressor
{
  SO_TYPED_CLASS_HEADER();

public:
  SoCustomDataCompressor();
  virtual ~SoCustomDataCompressor() {}
  virtual size_t compress(void *src, size_t srcLen, const TileInfo   &tileInfo);  
  virtual size_t uncompress(void *dest, size_t destLen, const TileInfo &tileInfo);
  virtual SbString getCompressionFormatName() const { return SbString("customComp"); }

  virtual bool isLossless() { return true; }

private:
  size_t myCompressionAlgo( std::vector<unsigned char>& dest, void *src, size_t srcLen);
  void myDecompressionAlgo(void* dest, size_t destLen, std::vector<unsigned char>& compressedData) ;

  size_t computeNeededSpace(size_t len);
};


