/*----------------------------------------------------------------------------------------
Example program.
Purpose : Demonstrate how to use a SoVolumeRenderingQuality property node
for lighting a volume.
author : Benjamin Grange
September 2005
----------------------------------------------------------------------------------------*/

//header files
#include <Inventor/nodes/SoSphere.h>
#include <Inventor/nodes/SoTranslation.h>
#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoDirectionalLight.h>
#include <Inventor/nodes/SoMaterial.h>
#include <VolumeViz/nodes/SoVolumeData.h>
#include <VolumeViz/nodes/SoVolumeRender.h>
#include <LDM/nodes/SoMultiDataSeparator.h>
#include <VolumeViz/nodes/SoVolumeRenderingQuality.h>
#include <LDM/nodes/SoTransferFunction.h>
#include <VolumeViz/nodes/SoVolumeRendering.h>

#include <VolumeViz/readers/SoVRAmFileReader.h>

#include <Inventor/STL/algorithm>
#include "SoCustomDataCompressor.h"


//main function
int main(int argc, char **argv)
{
  if (argc != 2)
  {
    std::cerr << "Usage: displayCustom file.ldm" << std::endl;
    return 0;
  }

  std::string tmpStr(argv[1]);
  std::transform(tmpStr.begin(), tmpStr.end(), tmpStr.begin(), ::tolower);
  if (tmpStr.find(".ldm") == std::string::npos)
  {
    std::cerr << "Usage: displayCustom file.ldm" << std::endl;
    return 0;
  }

  // Create the window
  Widget myWindow = SoXt::init(argv[0]);
  if (!myWindow)
    return 1;

  // Initialize of VolumeViz extension
  SoVolumeRendering::init();
  SoCustomDataCompressor::initClass();

  // Node to hold the volume data
  SoVolumeData* pVolData = new SoVolumeData();
  pVolData->fileName = argv[1];

  SoTransferFunction* pTransFunc = new SoTransferFunction;
  pTransFunc->predefColorMap = SoTransferFunction::SEISMIC;
  pTransFunc->minValue = 42;

  // Node in charge of drawing the volume
  SoVolumeRender* pVolRender = new SoVolumeRender;
  pVolRender->numSlicesControl = SoVolumeRender::ALL;

  // Assemble the scene graph
  // Note: SoVolumeRender must appear after the SoVolumeData node.
  SoSeparator *root = new SoSeparator;
  root->ref();
  root->addChild( pTransFunc );
  root->addChild( pVolData );
  root->addChild( pVolRender );

  // Set up viewer:
  SoXtExaminerViewer *myViewer = new SoXtExaminerViewer(myWindow);
  myViewer->setSceneGraph(root);
  myViewer->setTitle("Display ldm file compressed with a custom compressor");
  myViewer->show();

  SoXt::show(myWindow);
  SoXt::mainLoop();
  delete myViewer;
  root->unref();

  SoCustomDataCompressor::exitClass();
  SoVolumeRendering::finish();
  SoXt::finish();
  return 0;
}

