/*----------------------------------------------------------------------------------------
Example program.
Purpose : Demonstrate how to use the data transform feature of SoDataSet used for
example for attribute calculation.
author : Jerome Hummel
August 2005
----------------------------------------------------------------------------------------*/

//header files
#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>
#include <Inventor/nodes/SoSeparator.h>

#include <VolumeViz/nodes/SoVolumeData.h>
#include <VolumeViz/nodes/SoVolumeRender.h>
#include <VolumeViz/nodes/SoOrthoSlice.h>
#include <LDM/nodes/SoTransferFunction.h>
#include <VolumeViz/nodes/SoVolumeRendering.h>

#include "dataTransformer.h"

//main function
int main(int, char **argv)
{
  // Create the window
  Widget myWindow = SoXt::init(argv[0]);
  if (!myWindow) return 0;

  // Initialize of VolumeViz extension
  SoVolumeRendering::init();
  dataTransformer::initClass();

  SoLDMGlobalResourceParameters::setIgnoreFullyTransparentTiles(FALSE);

  SoVolumeData* pVolData = new SoVolumeData;
  pVolData->fileName  = "$OIVHOME/examples/data/VolumeViz/3DHEAD.ldm";

  //set the function that must be called before to store the data in main memory
  dataTransformer *transformer = new dataTransformer;
  pVolData->dataTransform.setValue(transformer);

  // Use a predefined colorMap with the SoTransferFunction
  SoTransferFunction* pTransFunc = new SoTransferFunction;
  pTransFunc->predefColorMap = SoTransferFunction::STANDARD;
  pTransFunc->minValue = 20;
  pTransFunc->maxValue = 250;

  // Node in charge of drawing the volume
  SoVolumeRender* pVolRender = new SoVolumeRender;
  pVolRender->samplingAlignment = SoVolumeRender::DATA_ALIGNED;

  // Assemble the scene graph
  // Note: SoVolumeRender must appear after the SoVolumeData node.
  SoSeparator *root = new SoSeparator;
  root->ref();
  root->addChild( pVolData );
  root->addChild( pTransFunc );
  root->addChild( pVolRender );

  // Set up viewer:
  SoXtExaminerViewer *myViewer = new SoXtExaminerViewer(myWindow);
  myViewer->setSceneGraph(root);
  myViewer->setTitle("Data Transform");
  myViewer->show();

  SoXt::show(myWindow);
  SoXt::mainLoop();
  delete myViewer;
  root->unref();

  dataTransformer::exitClass();
  SoVolumeRendering::finish();
  SoXt::finish();
  return 0;
}


