/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2020 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : David Beilloin (Sep 2008)
**=======================================================================*/
#include "dataTransformer.h"

#include <LDM/nodes/SoDataSet.h>
#include <Inventor/devices/SoCpuBufferObject.h>

SO_FIELDCONTAINER_SOURCE(dataTransformer);

//-----------------------------------------------------------------------------
void
dataTransformer::initClass()
{
	SO_FIELDCONTAINER_INIT_CLASS(dataTransformer, "dataTransformer", SoLDMDataTransform);
}

//-----------------------------------------------------------------------------
void
dataTransformer::exitClass()
{
	SO__FIELDCONTAINER_EXIT_CLASS(dataTransformer);
}

//-----------------------------------------------------------------------------
dataTransformer::dataTransformer( )
{
  SO_FIELDCONTAINER_CONSTRUCTOR(dataTransformer);
}

//-----------------------------------------------------------------------------
dataTransformer::~dataTransformer( )
{
}


//-----------------------------------------------------------------------------
void
dataTransformer::transformFunction(
    SoDataSet* /*ds*/,                      // current dataset
    const SbVec3i32& bufferDimension,   // tile dim
    SoBufferObject* bufferToTransform,  // buffer to transform
    const SbBox3i32& dataBox,           // position of tile in data space
    int resolutionLevel	                // resolution level of the tile
  )
{
  SoCpuBufferObject* cpuObj = new SoCpuBufferObject;
  cpuObj->ref();

  bufferToTransform->map(cpuObj,SoCpuBufferObject::READ_WRITE);
  unsigned char* buffer = (unsigned char*)cpuObj->map(SoCpuBufferObject::READ_WRITE);

  // Do the real work
  if(resolutionLevel == 1 || (resolutionLevel == 0 && dataBox.getMin() == SbVec3i32(0,0,0)))
  {
    int crossWidth = 10;
    int ijk = 0;
    for(int k = 0; k < bufferDimension[2]; k++)
    {
      for(int j = 0; j < bufferDimension[1]; j++)
      {
        for(int i = 0; i < bufferDimension[0]; i++)
        {
          buffer[ijk] = 0;
          if( j > bufferDimension[1]/2 - crossWidth && j < bufferDimension[1]/2 + crossWidth )
            buffer[ijk] = 125;
          else if( i > bufferDimension[0]/2 - crossWidth && i < bufferDimension[0]/2 + crossWidth )
            buffer[ijk] = 125;
          ijk++;
        }
      }
    }
  }

  cpuObj->unmap();
  bufferToTransform->unmap(cpuObj);
  cpuObj->unref();
}

