/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2020 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : David Beilloin (Sep 2008)
**=======================================================================*/
#ifndef LDM_DATA_TRANSFROMER_H
#define LDM_DATA_TRANSFROMER_H

#include <LDM/SoLDMLargeDataManagement.h>
#include <LDM/nodes/SoLDMDataTransform.h>
#include <LDM/nodes/SoDataSet.h>

#include <Inventor/fields/SoSubFieldContainer.h>
#include <Inventor/SbLinear.h>
#include <Inventor/SbBox.h>

#include <Inventor/sys/port.h>

class
#if defined(_WIN32) && defined(BUILDING_DLL)
   // When building the node as a DLL under Win32 we must explicitly
   // declare this entry point as visible outside the DLL.  The macro
   // BUILDING_DLL is defined in the node's source file.
   VC_DLL_EXPORT
#elif defined (_WIN32)
#ifndef OIV_DISABLE_AUTOLINK
#  pragma comment(lib,"dataTransformer.lib")
#endif
   VC_DLL_IMPORT
#else
   GCC_DLLEXPORT
#endif
dataTransformer : public SoLDMDataTransform
{
  SO_FIELDCONTAINER_HEADER(dataTransformer);
public:

  /**
   * Default constructor.
   */
  dataTransformer();

  /**
  * Data transform function.
  */
  virtual void transformFunction(
    SoDataSet* ds,                      // current dataset
    const SbVec3i32& bufferDimension,   // tile dim
    SoBufferObject* bufferToTransform,  // buffer to transform
    const SbBox3i32& dataBox,           // position of tile in data space
    int resolutionLevel	                // resolution level of the tile
  );

protected:
  /**
   * Destructor.
   */
  virtual ~dataTransformer();

};

#endif /* LDM_DATA_TRANSFROMER_H */


