#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoPerspectiveCamera.h>
#include <Inventor/SoPreferences.h>

#include <VolumeViz/nodes/SoVolumeData.h>
#include <VolumeViz/nodes/SoVolumeRenderingQuality.h>
#include <Inventor/actions/SoSearchAction.h>

#include <DialogViz/SoDialogVizAll.h>

#include "utils.h"

#include <Inventor/STL/algorithm>

const SbString DATAFILE = "$OIVHOME/examples/source/VolumeViz/edge2D/scene.iv";

SoVolumeRenderingQuality* g_vrq;
SoTopLevelDialog *myTopLevelDialog;

class InterfaceAuditor : public SoDialogAuditor
{
public:
  InterfaceAuditor(SoTopLevelDialog* topDialog){m_top = topDialog;}

private:
    SoTopLevelDialog* m_top;


  void dialogCheckBox(SoDialogCheckBox* cpt)
  {
    SbBool state = cpt->state.getValue();

    if(cpt->auditorID.getValue() == "edgeimage")
    {
      g_vrq->edgeDetect2D = state;
    } else if(cpt->auditorID.getValue() == "edgeluminance")
    {
      int bitmask = g_vrq->edgeDetect2DMethod.getValue();
      g_vrq->edgeDetect2DMethod = state? (bitmask|SoVolumeRenderingQuality::LUMINANCE):(bitmask&~SoVolumeRenderingQuality::LUMINANCE);
    }
    else if(cpt->auditorID.getValue() == "edgedepth")
    {
      int bitmask = g_vrq->edgeDetect2DMethod.getValue();
      g_vrq->edgeDetect2DMethod = state? (bitmask|SoVolumeRenderingQuality::DEPTH):(bitmask&~SoVolumeRenderingQuality::DEPTH);
    }
    else if(cpt->auditorID.getValue() == "edgegrad")
    {
      int bitmask = g_vrq->edgeDetect2DMethod.getValue();
      g_vrq->edgeDetect2DMethod = state? (bitmask|SoVolumeRenderingQuality::GRADIENT):(bitmask&~SoVolumeRenderingQuality::GRADIENT);

      SoDialogViz* dv = myTopLevelDialog->searchForAuditorId(SbString("surfacescalar"));
      dv->enable = state;
    }
    else if(cpt->auditorID.getValue() == "surfacescalar")
    {
      g_vrq->surfaceScalarExponent = state ? 8.f : 0.f;
    }
  }

  };

/*********************************************************************************/
int main(int, char **argv)
{
  Widget myWindow = SoXt::init(argv[0]);
  if (!myWindow)
    return 0;

  SoVolumeRendering::init();
  SoDialogViz::init();
  SoLDMGlobalResourceParameters::setViewCulling(FALSE);
  SoLDMGlobalResourceParameters::setViewpointRefinement(FALSE);
  SoLDMGlobalResourceParameters::setScreenResolutionCulling(FALSE);

  SoSeparator* scene = readFile(DATAFILE.toLatin1());
  if(!scene)
  {
    std::cerr << DATAFILE << " not found" << std::endl;
    return 0;
  }

  SbString InterfaceName = "$OIVHOME/examples/source/VolumeViz/edge2D/interface.iv";
  Widget parent = buildInterface(myWindow, InterfaceName.toLatin1(), "Viewer", &myTopLevelDialog);
  myTopLevelDialog->addAuditor(new InterfaceAuditor(myTopLevelDialog));


  SoSeparator *root = new SoSeparator;
  root->ref();
  root->addChild(scene);

  g_vrq = searchNode<SoVolumeRenderingQuality>(scene);
  if ( !g_vrq )
  {
    std::cerr << "SoVolumeRenderingQuality not found" << std::endl;
    return 0;
  }
  g_vrq->edgeDetect2DMethod = SoVolumeRenderingQuality::LUMINANCE|SoVolumeRenderingQuality::DEPTH;
  g_vrq->surfaceScalarExponent = 8.f;

  // Set up viewer:
  SoXtExaminerViewer *myViewer = new SoXtExaminerViewer(parent);
  myViewer->setSceneGraph(root);
  myViewer->show();

  SoXt::show(myWindow);
  SoXt::mainLoop();
  delete myViewer;
  root->unref();
  SoVolumeRendering::finish();
  SoDialogViz::finish();
  SoXt::finish();
  return 0;
}


