/*==============================================================================
***   THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),    ***
***             AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                ***
***                                                                          ***
*** REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS  ***
*** SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR  ***
*** WRITTEN AUTHORIZATION OF FEI S.A.S.                                      ***
***                                                                          ***
***                       RESTRICTED RIGHTS LEGEND                           ***
*** USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS ***
*** WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN ***
*** SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT ***
*** CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN ***
*** TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.        ***
***                                                                          ***
***                  COPYRIGHT (C) 1996-2021 BY FEI S.A.S,                   ***
***                           MERIGNAC, FRANCE                               ***
***                         ALL RIGHTS RESERVED                              ***
==============================================================================*/

#include <QFileDialog>
#include <Inventor/SoPreferences.h>
#include "GUIWidget.h"
#include "ui_GUIWidget.h"

GUIWidget::GUIWidget(QWidget* parent)
: QWidget(parent)
, ui(new Ui::GUIWidget)
{
  ui->setupUi(this);

  syncSliderAndSpinBox(ui->volumeOpacitySlider, ui->volumeOpacitySpinBox);

  // Connect Sliders to Signals
  connect(ui->volumeOpacitySpinBox, QOverload<double>::of(&QDoubleSpinBox::valueChanged), this, &GUIWidget::volumeOpacityChanged);

  // Connect Slice Axis to Signal
  connect(ui->sliceAxisX, &QRadioButton::toggled, this, &GUIWidget::sliceAxisChanged);
  connect(ui->sliceAxisY, &QRadioButton::toggled, this, &GUIWidget::sliceAxisChanged);
  connect(ui->sliceAxisZ, &QRadioButton::toggled, this, &GUIWidget::sliceAxisChanged);

  // Connect Clipping Side to Signal
  connect(ui->clippingSideFront, &QRadioButton::toggled, this, &GUIWidget::clippingSideChanged);
  connect(ui->clippingSideBack, &QRadioButton::toggled, this, &GUIWidget::clippingSideChanged);

  // Connect On/Off CheckBoxes Signals
  connect(ui->heightFieldDisplayCheckBox, &QCheckBox::stateChanged, this, &GUIWidget::horizonDisplayChanged);
  connect(ui->sliceDisplayCheckBox, &QCheckBox::stateChanged, this, &GUIWidget::sliceDisplayChanged);
  connect(ui->volumeRenderDisplayButton, &QRadioButton::toggled, this, &GUIWidget::volumeDisplayChanged);
  connect(ui->volumeSkinDisplayButton, &QRadioButton::toggled, this, &GUIWidget::volumeDisplayChanged);

  // Disable slice parameters when slice is not displayed
  connect(ui->sliceDisplayCheckBox, &QCheckBox::stateChanged, [this](int state) {
    ui->sliceAxisWidget->setEnabled(state);
    ui->clippingSideWidget->setEnabled(state);
  });
}

/******************************************************************************/
GUIWidget::~GUIWidget()
{
  delete ui;
}

/******************************************************************************/
void
GUIWidget::syncSliderAndSpinBox(QSlider* slider, QDoubleSpinBox* spinBox)
{
  static const int sliderRes = 50;

  slider->setRange(0, sliderRes);
  spinBox->setRange(0.0, 1.0);
  spinBox->setSingleStep((spinBox->maximum() - spinBox->minimum()) / ((double) sliderRes));

  // sync height scale slider and spin box
  connect(slider, &QSlider::valueChanged, spinBox, [spinBox](int value) {
    const double scale = spinBox->maximum() - spinBox->minimum();
    spinBox->setValue(spinBox->minimum() + scale * (value / (double) sliderRes));
  });
  connect(spinBox, QOverload<double>::of(&QDoubleSpinBox::valueChanged), slider, [slider, spinBox](double value) {
    const double scale = spinBox->maximum() - spinBox->minimum();
    slider->setValue(((value / scale) - spinBox->minimum()) * sliderRes);
  });
}

/******************************************************************************/
void
GUIWidget::setVolumeOpacity(double value)
{
  ui->volumeOpacitySpinBox->setValue(value);
}

/******************************************************************************/
double
GUIWidget::getVolumeOpacity() const
{
  return ui->volumeOpacitySpinBox->value();
}

/******************************************************************************/
void
GUIWidget::displayHorizon(bool value)
{
  ui->heightFieldDisplayCheckBox->setChecked(value);
}

/******************************************************************************/
bool
GUIWidget::isHorizonDisplayed() const
{
  return ui->heightFieldDisplayCheckBox->isChecked();
}

/******************************************************************************/
void
GUIWidget::displaySlice(bool value)
{
  ui->sliceDisplayCheckBox->setChecked(value);
  ui->sliceAxisWidget->setEnabled(value);
  ui->clippingSideWidget->setEnabled(value);
}

/******************************************************************************/
bool
GUIWidget::isSliceDisplayed() const
{
  return ui->sliceDisplayCheckBox->isChecked();
}

/******************************************************************************/
void
GUIWidget::displayVolumeRender(bool value)
{
  ui->volumeRenderDisplayButton->setChecked(value);
}

/******************************************************************************/
bool
GUIWidget::isVolumeRenderDisplayed() const
{
  return ui->volumeRenderDisplayButton->isChecked();
}

/******************************************************************************/
void
GUIWidget::displayVolumeSkin(bool value)
{
  ui->volumeSkinDisplayButton->setChecked(value);
}

/******************************************************************************/
bool
GUIWidget::isVolumeSkinDisplayed() const
{
  return ui->volumeSkinDisplayButton->isChecked();
}

/******************************************************************************/
void
GUIWidget::setSliceAxis(int sliceAxis)
{
  switch (sliceAxis)
  {
  default:
  case 0:
    ui->sliceAxisX->setChecked(true);
    break;
  case 1:
    ui->sliceAxisY->setChecked(true);
    break;
  case 2:
    ui->sliceAxisZ->setChecked(true);
    break;
  }
}

/******************************************************************************/
int
GUIWidget::getSliceAxis() const
{
  if (ui->sliceAxisX->isChecked())
    return 0;
  else if (ui->sliceAxisY->isChecked())
    return 1;
  else
    return 2;
}

/******************************************************************************/
void
GUIWidget::setClippingSide(int clippingSide)
{
  switch (clippingSide)
  {
  default:
  case 0:
    ui->clippingSideFront->setChecked(true);
    break;
  case 1:
    ui->clippingSideBack->setChecked(true);
    break;
  }
}

/******************************************************************************/
int
GUIWidget::getClippingSide() const
{
  if (ui->clippingSideFront->isChecked())
    return 0;
  else
    return 1;
}
