/*==============================================================================
***   THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),    ***
***             AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                ***
***                                                                          ***
*** REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS  ***
*** SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR  ***
*** WRITTEN AUTHORIZATION OF FEI S.A.S.                                      ***
***                                                                          ***
***                       RESTRICTED RIGHTS LEGEND                           ***
*** USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS ***
*** WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN ***
*** SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT ***
*** CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN ***
*** TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.        ***
***                                                                          ***
***                  COPYRIGHT (C) 1996-2021 BY FEI S.A.S,                   ***
***                           MERIGNAC, FRANCE                               ***
***                         ALL RIGHTS RESERVED                              ***
==============================================================================*/

#pragma once

#include <QWidget>

namespace Ui
{
  class GUIWidget;
}

class QSlider;
class QDoubleSpinBox;

class GUIWidget : public QWidget
{
  Q_OBJECT

public:
  explicit GUIWidget( QWidget* parent = nullptr );
  ~GUIWidget();

  void setVolumeOpacity( double value );
  double getVolumeOpacity() const;

  void displayHorizon(bool value);
  bool isHorizonDisplayed() const;

  void displaySlice(bool value);
  bool isSliceDisplayed() const;

  void displayVolumeRender(bool value);
  bool isVolumeRenderDisplayed() const;

  void displayVolumeSkin(bool value);
  bool isVolumeSkinDisplayed() const;

  void setSliceAxis(int sliceAxis);
  int getSliceAxis() const;

  void setClippingSide(int clippingSide);
  int getClippingSide() const;

signals:
  void volumeOpacityChanged();
  void horizonDisplayChanged();
  void sliceDisplayChanged();
  void volumeDisplayChanged();
  void sliceAxisChanged();
  void clippingSideChanged();

private:
  static void syncSliderAndSpinBox(QSlider* slider, QDoubleSpinBox* spinBox);

  Ui::GUIWidget* ui;
};
