//!oiv_include <VolumeViz/vvizGetData_frag.h>
//!oiv_include <VolumeViz/vvizfnc_frag.h>

uniform VVizDataSetId propertyID;

uniform float isolineStep;
uniform float firstIsoline;
uniform int heightRange;


vec4 VVizComputeFragmentColor( VVIZ_DATATYPE vox, vec3 texCoord )
{
  const float EPSILON = 0.5;
  VVIZ_DATATYPE propertyValue = VVizGetData( propertyID, texCoord );
  // Retrieve the default color computed by VolumeViz
  vec4 color = VVizComputeVolumeRendering( propertyValue );

  // PropertyValue are normalized, multiply by maxValue
  propertyValue *= heightRange;

  // Current value is an isoline if is equal to firstIsoline or is a modulo to this value.
  float isIsoline = 0.0;
  float modulo = mod( propertyValue - firstIsoline, isolineStep );
  bool isIsolines = ( ( modulo < EPSILON && modulo > -EPSILON ) || ( firstIsoline - EPSILON < propertyValue && propertyValue < firstIsoline + EPSILON ) );

  // If isoline, mix the default color with black.
  if( isIsolines )
    color = mix( color, vec4( 0, 0, 0, 1 ), 0.5 );

  return color;
}
