/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2020 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
/*=======================================================================
** Author      : VSG (feb 2014)
**=======================================================================*/

#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>
#include <Inventor/nodes/SoFragmentShader.h>
#include <Inventor/nodes/SoGradientBackground.h>
#include <Inventor/nodes/SoSeparator.h>

#include <VolumeViz/nodes/SoHeightFieldGeometry.h>
#include <VolumeViz/nodes/SoHeightFieldRender.h>
#include <VolumeViz/nodes/SoVolumeShader.h>

#include <LDM/nodes/SoTransferFunction.h>

// Include used for the GUI.
#include <DialogViz/auditors/SoDialogAuditor.h>
#include <DialogViz/dialog/SoDialogCustom.h>
#include <DialogViz/dialog/SoDialogRealSlider.h>
#include <DialogViz/dialog/SoDialogViz.h>
#include <DialogViz/dialog/SoTopLevelDialog.h>

// Shaders parameters
SoShaderParameter1f* g_IsolineStep = NULL;
SoShaderParameter1f* g_FirstIsoline = NULL;

#define DATASET_PATH "$OIVHOME/examples/data/VolumeViz/horizons/horizon.ldm"
#define DEMO_ROOT_DIR "$OIVHOME/examples/source/VolumeViz/horizonIsolines"

// Class used to interpret event from the GUI.
class auditorClass : public SoDialogAuditor
{
  // When slider value has changed.
  void
  dialogRealSlider( SoDialogRealSlider* cpt )
  {
    float value = cpt->value.getValue();
    if ( cpt->auditorID.getValue() == "IsolineStep" )
    {
      g_IsolineStep->value.setValue( value );
    }
    else if ( cpt->auditorID.getValue() == "FirstIsoline" )
    {
      g_FirstIsoline->value.setValue( value );
    }
  }
};

SoNode*
buildSceneGraph()
{
  SoSeparator* root = new SoSeparator;
  root->addChild( new SoGradientBackground );

  SoSeparator* separator = new SoSeparator;
  root->addChild( separator );

  SoScale* scale = new SoScale;
  scale->scaleFactor.setValue( 1.f, 1.f, 0.2f );
  separator->addChild( scale );

  SoTransferFunction* transfertFunction = new SoTransferFunction;
  transfertFunction->predefColorMap.setValue( SoTransferFunction::STANDARD );
  separator->addChild( transfertFunction );

  SoHeightFieldGeometry* geometry = new SoHeightFieldGeometry;
  geometry->fileName.setValue( DATASET_PATH );
  separator->addChild( geometry );

  // Add shader program
  // Set pipeline shader and associated uniforms.
  {
    // Initialize and set the shader program.
    SoVolumeShader* shaderProgram = new SoVolumeShader;
    separator->addChild( shaderProgram );

    SoFragmentShader* fragment =
      shaderProgram->setFragmentShader( SoVolumeShader::FRAGMENT_COMPUTE_COLOR, SbString( DEMO_ROOT_DIR ) + "/composition.glsl" );

    fragment->addShaderParameter<SoShaderParameter1i>( "propertyID", geometry->dataSetId.getValue() );
    // Set the uniform variable which allow to change the step between isolines.
    g_IsolineStep = fragment->addShaderParameter1f( "isolineStep", 10.f );
    // Set the uniform variable which allow to change the height of isoline.
    g_FirstIsoline = fragment->addShaderParameter1f( "firstIsoline", 1.f );

    int64_t min, max;
    geometry->getMinMax( min, max );
    // Set the uniform variable which allow to convert height values.
    fragment->addShaderParameter<SoShaderParameter1i>( "heightRange", static_cast<int32_t>( max - min ) );
  }

  separator->addChild( new SoHeightFieldRender );

  return root;
}

int
main( int /*argc*/, char** argv )
{
  Widget window = SoXt::init( argv[0] );

  SoVolumeRendering::init();

  // DialogViz functions used to build the GUI.
  ////////////////////////////////////////////
  SoDialogViz::init();
  SoTopLevelDialog* topLevelDialog = (SoTopLevelDialog*) SoDialogViz::loadFromFile( SbString( DEMO_ROOT_DIR ) + "/interface.iv" );
  topLevelDialog->buildDialog( window, TRUE );
  SoDialogCustom* customNode = (SoDialogCustom*) topLevelDialog->searchForAuditorId( "viewer" );
  Widget myWindow = customNode->getWidget();
  auditorClass* auditor = new auditorClass;
  topLevelDialog->label.setValue( "HeightField isolines" );
  topLevelDialog->addAuditor( auditor );
  topLevelDialog->show();
  ////////////////////////////////////////////
  // End of DialogViz function

  SoXtExaminerViewer* myViewer = new SoXtExaminerViewer( myWindow );
  myViewer->setTitle( "HeightFieldRender with isolines" );
  {
    SoRef<SoNode> root = buildSceneGraph();
    myViewer->setSceneGraph( root.ptr() );
    myViewer->show();
    myViewer->viewAll();
    SoXt::show( window );
    SoXt::mainLoop();
  }

  delete auditor;
  delete myViewer;

  SoDialogViz::finish();
  SoVolumeRendering::finish();
  SoXt::finish();
  return EXIT_SUCCESS;
}
