/*=============================================================================
** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),       **
**              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                **
**                                                                           **
**  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS  **
**  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR  **
**  WRITTEN AUTHORIZATION OF FEI S.A.S.                                      **
**                                                                           **
**                        RESTRICTED RIGHTS LEGEND                           **
**  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS **
**  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN **
**  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT **
**  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN **
**  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.        **
**                                                                           **
**                   COPYRIGHT (C) 1996-2020 BY FEI S.A.S,                   **
**                             MERIGNAC, FRANCE                              **
**                           ALL RIGHTS RESERVED                             **
=============================================================================*/

#include "GUIWidget.h"
#include "ui_GUIWidget.h"

GUIWidget::GUIWidget( QWidget* parent )
: QWidget( parent )
, ui( new Ui::GUIWidget )
{
  ui->setupUi( this );

  static const int sliderRes = 50;

  ui->curvatureSlider->setRange( 0, sliderRes );
  ui->curvatureSpinBox->setRange( 0.0, 1.0 );
  ui->curvatureSpinBox->setSingleStep( (ui->curvatureSpinBox->maximum() - ui->curvatureSpinBox->minimum()) / ((double) sliderRes) );

  ui->heightScaleSlider->setRange( 0, sliderRes );
  ui->heightScaleSpinBox->setRange( 0.0, 1.0 );
  ui->heightScaleSpinBox->setSingleStep( (ui->heightScaleSpinBox->maximum() - ui->heightScaleSpinBox->minimum()) / ((double) sliderRes) );

  // sync curvature slider and spin box
  connect( ui->curvatureSlider, &QSlider::valueChanged, ui->curvatureSpinBox, [this]( int value ) {
    const double scale = ui->curvatureSpinBox->maximum() - ui->curvatureSpinBox->minimum();
    ui->curvatureSpinBox->setValue( ui->curvatureSpinBox->minimum() + scale * (value / (double) sliderRes) );
  } );
  connect( ui->curvatureSpinBox, QOverload<double>::of( &QDoubleSpinBox::valueChanged ), ui->curvatureSlider, [this]( double value ) {
    const double scale = ui->curvatureSpinBox->maximum() - ui->curvatureSpinBox->minimum();
    ui->curvatureSlider->setValue( ((value / scale) - ui->curvatureSpinBox->minimum()) * sliderRes );
  } );

  // sync height scale slider and spin box
  connect( ui->heightScaleSlider, &QSlider::valueChanged, ui->heightScaleSpinBox, [this]( int value ) {
    const double scale = ui->heightScaleSpinBox->maximum() - ui->heightScaleSpinBox->minimum();
    ui->heightScaleSpinBox->setValue( ui->heightScaleSpinBox->minimum() + scale * (value / (double) sliderRes) );
  } );
  connect( ui->heightScaleSpinBox, QOverload<double>::of( &QDoubleSpinBox::valueChanged ), ui->heightScaleSlider, [this]( double value ) {
    const double scale = ui->heightScaleSpinBox->maximum() - ui->heightScaleSpinBox->minimum();
    ui->heightScaleSlider->setValue( ((value / scale) - ui->heightScaleSpinBox->minimum()) * sliderRes );
  } );

  connect( ui->curvatureSpinBox,   QOverload<double>::of( &QDoubleSpinBox::valueChanged ), this, &GUIWidget::curvatureModified );
  connect( ui->heightScaleSpinBox, QOverload<double>::of( &QDoubleSpinBox::valueChanged ), this, &GUIWidget::heightScaleModified );
}

/******************************************************************************/
GUIWidget::~GUIWidget()
{
  delete ui;
}

/******************************************************************************/
void
GUIWidget::setCurvature( double value )
{
  ui->curvatureSpinBox->setValue( value );
}

/******************************************************************************/
void
GUIWidget::setHeightScale( double value )
{
  ui->heightScaleSpinBox->setValue( value );
}

/******************************************************************************/
double
GUIWidget::getCurvature() const
{
  return ui->curvatureSpinBox->value();
}

/******************************************************************************/
double
GUIWidget::getHeightScale() const
{
  return ui->heightScaleSpinBox->value();
}
