//!oiv_include <VolumeViz/vvizGetData_frag.h>
//!oiv_include <VolumeViz/vvizfnc_frag.h>
//!oiv_include <VolumeViz/vvizNpr_frag.h>


////////////////////////////////////////////////////////////////////////
// Simple multi-channel fragment shader for volume rendering
//
// Notes
// 1) This version is for volume rendering.
//    (Must make a separate version for slice/skin rendering.)
// 2) This version is for 3 channels of data.
//    (Must make a separate version for 2 channels.)
// 3) This shader assumes that 3D textures are used.
// 4) It seems reasonable to sum the color (RGB) components.  But we
//    don't necessarily want the volume to be more opaque where
//    values exist in multiple channels, so we'll use the highest
//    opacity value in any of the channels.  Does that make sense?
uniform VVizDataSetId voldata1;
uniform VVizDataSetId voldata2;
uniform VVizDataSetId voldata3;
uniform sampler2D transfer;

vec4 VVizComputeFragmentColor(VVizDataSetId data, vec3 rayDir, inout VVizVoxelInfo voxelInfoFront, in VVizVoxelInfo voxelInfoBack, int maskId)
{
  // Lookup to get voxel values for this fragment
  float val1 = VVizGetData(voldata1, voxelInfoFront.texCoord);
  float val2 = VVizGetData(voldata2, voxelInfoFront.texCoord);
  float val3 = VVizGetData(voldata3, voxelInfoFront.texCoord);

  // Lookup to get color/alpha values from voxel values
  vec4 clr1 = texture( transfer, vec2(val1, 0.15) );
  vec4 clr2 = texture( transfer, vec2(val2, 0.5) );
  vec4 clr3 = texture( transfer, vec2(val3, 0.75) );
  
  // Combine color values but use highest alpha value
  vec4 res;
  res.xyz = clr1.rgb + clr2.rgb + clr3.rgb;
  res.w = max(clr1.a,max(clr2.a,clr3.a));

  return res;
}
