//!oiv_include <VolumeViz/vvizGetData_frag.h>
//!oiv_include <VolumeViz/vvizfnc_frag.h>

uniform VVizDataSetId voldata1;
uniform VVizDataSetId voldata2;
uniform VVizDataSetId voldata3;

vec4 VVizComputeFragmentColor(VVizDataSetId data, vec3 rayDir, inout VVizVoxelInfo voxelInfo, in VVizVoxelInfo voxelInfoBack, int maskId)
{
  // Lookup to get voxel values for this fragment
  float val1 = VVizGetData(voldata1, voxelInfo.texCoord);
  float val2 = VVizGetData(voldata2, voxelInfo.texCoord);
  float val3 = VVizGetData(voldata3, voxelInfo.texCoord);

  // Lookup to get color/alpha values from voxel values of each datasets
  vec4 clr1 = VVizComputeVolumeRendering(val1, 1);
  vec4 clr2 = VVizComputeVolumeRendering(val2, 2);
  vec4 clr3 = VVizComputeVolumeRendering(val3, 3);
  
  vec4 result;
  result.rgb = clr1.rgb + clr2.rgb + clr3.rgb;
  result.a   = max(clr1.a,max(clr2.a,clr3.a));
  return result;
}

