#define BUILDING_DLL 1

#include "CPUDataCompositor.h"

#include <Inventor/devices/SoCpuBufferObject.h>

#include <Inventor/SbElapsedTime.h> 

SO_NODE_SOURCE( CPUDataCompositor )

//-----------------------------------------------------------------------------
CPUDataCompositor::CPUDataCompositor()
{
  SO_NODE_CONSTRUCTOR( CPUDataCompositor );

  //Automatically set preDefCompositor field to NONE
  preDefCompositor = SoDataCompositor::NONE;
}

//-----------------------------------------------------------------------------
CPUDataCompositor::~CPUDataCompositor()
{
}

//-----------------------------------------------------------------------------
void
CPUDataCompositor::initClass()
{
  SO__NODE_INIT_CLASS(CPUDataCompositor, "CPUDataCompositor", SoDataCompositor);
}

//-----------------------------------------------------------------------------
void
CPUDataCompositor::exitClass()
{
  SO__NODE_EXIT_CLASS(CPUDataCompositor);
}

//-----------------------------------------------------------------------------
// Implement custom compose method
void
CPUDataCompositor::compose(int /*numDataSet*/, const SbVec3i32& /*tileDimension*/,
               int* /*vdid*/, SoBufferObject** /*inputBuffer*/, SoDataCompositor::DataType* /*dataTypes*/,
               SoBufferObject* /*outputBuffer*/)
{
  SoDebugError::post("CPUDataCompositor::compose","This demo only implement compose method for converted input");
  return;
}

void 
CPUDataCompositor::compose( int numVolumeData, const SbVec3i32& tileDimension,
                       int* vdid, SoBufferObject** inputBufferObject, SoBufferObject* outputBufferObject )
{
  if ( rgbaMode.getValue() == FALSE )
  {
    // Check that we are using the right type of data as
    if (dataType.getValue()!=SbDataType::UNSIGNED_BYTE)
    {
      SoDebugError::post("CPUDataCompositor::compose","Only implemented for UNSIGNED_BYTE data type");
      return;
    }

    composeInCPU( numVolumeData, tileDimension,vdid, inputBufferObject, outputBufferObject );
  }
  else
  {
    composeRGBAInCPU( numVolumeData, tileDimension,vdid, inputBufferObject, outputBufferObject );
  }
}

//-----------------------------------------------------------------------------
// Implement custom compose method
void 
CPUDataCompositor::composeRGBAInCPU( int numVolumeData, const SbVec3i32& tileDimension,
                       int* /*vdid*/, SoBufferObject** inputBufferObject, SoBufferObject* outputBufferObject )
{
  SbElapsedTime timer;

  // Map the output buffer on CPU to get a classical pointer
  SoCpuBufferObject* cpuObj = new SoCpuBufferObject;
  cpuObj->ref();

  SoCpuBufferObject* cpuInObj = new SoCpuBufferObject;
  cpuInObj->ref();

  outputBufferObject->map(cpuObj,SoCpuBufferObject::SET);
  void *outputBuffer = cpuObj->map(SoCpuBufferObject::SET);

  size_t nbElem = tileDimension[0] * tileDimension[1] * tileDimension[2];

  //loop on each datum of the tile and do RGBA combining
  for(int n = 0; n < numVolumeData; n++ )
  {
    // each volume is colored in a different color
    unsigned int color = ((0xff) << ((n+1)*4) ) ;
    // set alpha to 0
    color = color & 0x00;

    // map the current input buffer inside CPU
    inputBufferObject[n]->map(cpuInObj,SoCpuBufferObject::READ_ONLY);
    void *inputBuffer = cpuInObj->map(SoCpuBufferObject::READ_ONLY);
    {
      unsigned int *pOut = (unsigned int*)(outputBuffer);
      unsigned int *pIn  = (unsigned int*)(inputBuffer);
      
      timer.reset();
      {
        for(size_t ii = 0; ii < nbElem; ++ii )
        {
          if (n==0)
          {
            unsigned int inValue = *(pIn++);
            if ( inValue <40 || inValue>250)
              *(pOut++) = 0;
            else
              *(pOut++) = 0xffffffff;
          }
          else
          {
            *(pOut++) *= *(pIn++);
          }
        }
      }
     
      //printf( "CPU: Compute time: %fs\n", elapsed );

    }
    // unmap the current input buffer
    cpuInObj->unmap();
    inputBufferObject[n]->unmap(cpuInObj);
  }
  cpuInObj->unref();

  // unmap output buffer object
  cpuObj->unmap();
  outputBufferObject->unmap(cpuObj);
  cpuObj->unref();
}

//-----------------------------------------------------------------------------
// Implement custom compose method
void 
CPUDataCompositor::composeInCPU( int numVolumeData, const SbVec3i32& tileDimension,
                       int* /*vdid*/, SoBufferObject** inputBufferObject, SoBufferObject* outputBufferObject )
{
  // Map the output buffer on CPU to get a classical pointer
  SoCpuBufferObject* cpuObj = new SoCpuBufferObject;
  cpuObj->ref();

  SoCpuBufferObject* cpuInObj = new SoCpuBufferObject;
  cpuInObj->ref();


  size_t nbElem = tileDimension[0] * tileDimension[1] * tileDimension[2];

  // copy first input buffer inside outputBuffer
  outputBufferObject->memcpy( inputBufferObject[0] );

  outputBufferObject->map(cpuObj,SoCpuBufferObject::SET);
  void *outputBuffer = cpuObj->map(SoCpuBufferObject::SET);

  //loop on each datum of the tile and do multiplication
  for(int n = 1; n < numVolumeData; n++ )
  {
    // map the current input buffer inside CPU
    inputBufferObject[n]->map(cpuInObj,SoCpuBufferObject::READ_ONLY);
    void *inputBuffer = cpuInObj->map(SoCpuBufferObject::READ_ONLY);
    {
      unsigned char *pOut = (unsigned char*)(outputBuffer);
      unsigned char *pIn  = (unsigned char*)(inputBuffer);

      {
        for(size_t ii = 0; ii < nbElem; ++ii )
          *(pOut++) *= *(pIn++);

      }
    }
    // unmap the current input buffer
    cpuInObj->unmap();
    inputBufferObject[n]->unmap(cpuInObj);
  }

  cpuInObj->unref();

  // unmap output buffer object
  cpuObj->unmap();
  outputBufferObject->unmap(cpuObj);
  cpuObj->unref();
}
