/*----------------------------------------------------------------------------------------
Example program.
Purpose : Demonstrate how to render an heightfield with a SoHeightFieldRender and 3 properties.
----------------------------------------------------------------------------------------*/

//header files
#include <ScaleViz/SoScaleViz.h>
#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoGradientBackground.h>
#include <Inventor/nodes/SoDirectionalLight.h>
#include <Inventor/nodes/SoLightModel.h>
#include <Inventor/nodes/SoPhysicalMaterial.h>
#include <Inventor/nodes/SoScale.h>
#include <Inventor/nodes/SoSwitch.h>

#include <Inventor/helpers/SbFileHelper.h>

#include <VolumeViz/nodes/SoVolumeShader.h>
#include <VolumeViz/nodes/SoVolumeRendering.h>
#include <VolumeViz/nodes/SoHeightFieldGeometry.h>
#include <VolumeViz/nodes/SoHeightFieldProperty.h>
#include <VolumeViz/nodes/SoHeightFieldRender.h>
#include <LDM/nodes/SoMultiDataSeparator.h>
#include <LDM/nodes/SoTransferFunction.h>

#include "utils.h"

SoSwitch* g_switchProps = NULL;
SoSwitch* g_switchProp0 = NULL;
SoSwitch* g_switchProp1 = NULL;
SoSwitch* g_switchProp2 = NULL;
SoFragmentShader* g_frag = NULL;

class InterfaceAuditor : public SoDialogAuditor
{
public:
  InterfaceAuditor(SoTopLevelDialog* topDialog){m_top = topDialog;}

private:
  SoTopLevelDialog* m_top;


  void dialogCheckBox(SoDialogCheckBox* cpt)
  {
    SbBool state = cpt->state.getValue();

    if ( cpt->auditorID.getValue() == "Prop0" )
    {
      g_switchProp0->whichChild = state ? -3 : -1;
    }
    else if ( cpt->auditorID.getValue() == "Prop1" )
    {
      g_switchProp1->whichChild = state ? -3 : -1;
      g_frag->addShaderParameter1i("isProp1", state);
    }
    else if ( cpt->auditorID.getValue() == "Prop2" )
    {
      g_switchProp2->whichChild = state ? -3 : -1;
      g_frag->addShaderParameter1i("isProp2", state);
    }
    if ( g_switchProp0->whichChild.getValue() == -1 &&
         g_switchProp1->whichChild.getValue() == -1 &&
         g_switchProp2->whichChild.getValue() == -1 )
    {
      g_switchProps->whichChild = -1;
    }
    else if ( g_switchProps->whichChild.getValue() == -1 )
    {
      g_switchProps->whichChild = -3;
    }
  }

};

/*******************************************************************************/
int main(int, char **argv)
{
  // Create the window
  Widget myWindow = SoXt::init(argv[0]);
  if (!myWindow) return 0;

  // Initialize of VolumeViz extension
  SoVolumeRendering::init();
  SoDialogViz::init();

  // Add a scale on z
  SoScale* scale = new SoScale;
  scale->scaleFactor = SbVec3f(1.f, 1.f, 0.1f);

  // Node to hold heights as geometry
  SoHeightFieldGeometry* hg = new SoHeightFieldGeometry();
  hg->fileName = SbFileHelper::expandString("$OIVHOME/examples/data/VolumeViz/horizons/horizon.ldm");
  hg->dataSetId = 1;

  // Node to hold heights as a property
  SoHeightFieldProperty* hp0 = new SoHeightFieldProperty();
  hp0->fileName = SbFileHelper::expandString("$OIVHOME/examples/data/VolumeViz/horizons/horizon.ldm");
  hp0->dataSetId = 2;

  SoHeightFieldProperty* hp1 = new SoHeightFieldProperty();
  hp1->fileName = SbFileHelper::expandString("$OIVHOME/examples/data/VolumeViz/horizons/property1.ldm");
  hp1->dataSetId = 3;

  SoHeightFieldProperty* hp2 = new SoHeightFieldProperty();
  hp2->fileName = SbFileHelper::expandString("$OIVHOME/examples/data/VolumeViz/horizons/property2.ldm");
  hp2->dataSetId = 4;

  SoVolumeShader* shader = new SoVolumeShader;
  g_frag = shader->setFragmentShader(SoVolumeShader::FRAGMENT_COMPUTE_COLOR, SbFileHelper::expandString("$OIVHOME/examples/source/VolumeViz/multiData/horizonGpuCompose/composition.glsl"));
  g_frag->addShaderParameter1i("prop0", 2);
  g_frag->addShaderParameter1i("prop1", 3);
  g_frag->addShaderParameter1i("prop2", 4);
  g_frag->addShaderParameter1i("isProp1", 1);
  g_frag->addShaderParameter1i("isProp2", 1);

  g_switchProp0 = new SoSwitch;
  g_switchProp0->whichChild = -3;
  g_switchProp0->addChild(hp0);

  g_switchProp1 = new SoSwitch;
  g_switchProp1->whichChild = -3;
  g_switchProp1->addChild(hp1);

  g_switchProp2 = new SoSwitch;
  g_switchProp2->whichChild = -3;
  g_switchProp2->addChild(hp2);

  g_switchProps = new SoSwitch;
  g_switchProps->whichChild = -3;

  g_switchProps->addChild(shader);
  g_switchProps->addChild(g_switchProp0);
  g_switchProps->addChild(g_switchProp1);
  g_switchProps->addChild(g_switchProp2);

  SoHeightFieldRender* hf = new SoHeightFieldRender;

  SoMultiDataSeparator* mds = new SoMultiDataSeparator;
  mds->addChild(scale);
  mds->addChild(g_switchProps);
  mds->addChild(hg);
  mds->addChild(hf);

  SoTransferFunction* tf = new SoTransferFunction;
  tf->predefColorMap = SoTransferFunction::STANDARD;

  SoLightModel* lightModel = new SoLightModel;
  lightModel->model = SoLightModel::PHYSICALLY_BASED;

  //Material
  SoPhysicalMaterial* material = new SoPhysicalMaterial;
  material->baseColor = SbColorRGBA( 1.0f, 1.0f, 1.0f, 1.0f );
  material->specular = 1.0f;
  material->roughness = 0.4f;

  // Assemble the scene graph
  SoSeparator *root = new SoSeparator;
  root->ref();

  root->addChild(new SoGradientBackground);
  root->addChild( new SoDirectionalLight ); // additional light source
  root->addChild( lightModel );
  root->addChild( material );
  root->addChild( tf );
  root->addChild( mds );

  SoTopLevelDialog *myTopLevelDialog;
  SbString InterfaceFile = "$OIVHOME/examples/source/VolumeViz/multiData/horizonGpuCompose/interface.iv";
  Widget parent = buildInterface(myWindow, InterfaceFile.toLatin1(), "Viewer", &myTopLevelDialog);
  myTopLevelDialog->addAuditor(new InterfaceAuditor(myTopLevelDialog));

  // Set up viewer:
  SoXtExaminerViewer *myViewer = new SoXtExaminerViewer(parent);
  myViewer->setTransparencyType(SoGLRenderAction::OPAQUE_FIRST);
  myViewer->setSceneGraph(root);
  myViewer->setTitle("Horizon GPU Compose");
  myViewer->viewAll();
  myViewer->show();

  myViewer->bindNormalContext();
  if (!SoHeightFieldRender::isSupported())
  {
    SoError::post("Some extensions are not supported on the current platform to launch this demo\n");
    return -1;
  }
  myViewer->unbindNormalContext();

  SoXt::show(myWindow);
  SoXt::mainLoop();
  delete myViewer;
  root->unref();

  SoDialogViz::finish();
  SoVolumeRendering::finish();
  SoXt::finish();
  return 0;
}


