//!oiv_include <VolumeViz/vvizfnc_frag.h>
//!oiv_include <VolumeViz/vvizGetData_frag.h>
//!oiv_include <VolumeViz/vvizTransferFunction_frag.h>

uniform VVizDataSetId volumeLabel;
uniform VVizDataSetId volumeData;

vec4 VVizComputeFragmentColor(VVizDataSetId dataset, vec3 rayDir, inout VVizVoxelInfo voxelInfoFront, in VVizVoxelInfo voxelInfoBack, int mask)
{
  // Get the data value at this position. Value need to be converted to data range.
  VVIZ_DATATYPE labelValue = VVizGetRawData(volumeLabel, VVizGetNearestCoord(voxelInfoFront)) * 255.;
  // Get the label for this data value and apply corresponding transfer function.
  VVIZ_DATATYPE sf = VVizGetData(volumeData, voxelInfoFront.texCoord);

  return VVizTransferFunction(sf, int(labelValue));
}
