#include "utils.h"

#include <DialogViz/SoDialogVizAll.h>
#include <DialogViz/dialog/SoTopLevelDialog.h>
#include <VolumeViz/nodes/SoVolumeData.h>


SoSeparator *
readFile(const char *filename)
{
  // Open the input file
  SoInput mySceneInput;
  if (!mySceneInput.openFile(filename))
  {
    std::cerr << "Cannot open file " << filename << std::endl;
    return NULL;
  }

  // Read the whole file into the database
  SoSeparator *myGraph = SoDB::readAll(&mySceneInput);
  if (myGraph == NULL)
  {
    std::cerr << "Problem reading file" << std::endl;
    return NULL;
  }

  mySceneInput.closeFile();
  return myGraph;
}

SoGroup *g_myGroup = NULL;

void releaseInterface()
{
  SO_UNREF_RESET(g_myGroup);
}

Widget
buildInterface(Widget window, const char* filename, const char* viewer,
               SoTopLevelDialog** myTopLevelDialog)
{
  SoInput myInput;
  if (! myInput.openFile( filename ))
    return NULL;

  g_myGroup = SoDB::readAll( &myInput );
  if (! g_myGroup)
    return NULL;
  g_myGroup->ref();

  *myTopLevelDialog = (SoTopLevelDialog *)g_myGroup->getChild( 0 );

  SoDialogCustom *customNode = (SoDialogCustom *)(*myTopLevelDialog)->searchForAuditorId(SbString(viewer));

  (*myTopLevelDialog)->buildDialog( window, customNode != NULL );
  (*myTopLevelDialog)->show();

  return customNode ? customNode->getWidget() : window;
}

//------------------------------------------------------------------------------
// convenient function to retrieve boundingBox of specified node.
// If node contains SoVolumeData, use SoVolumeData extent.
SbBox3f getBbox( SoNode* node )
{
  // retrieve root node of volume data and compute its boundingBox.
  // Try to find an SoVolumeData in specified volumeData. If SoVolumeData found,
  // use its extend as bbox. Else, apply an SoGetBoundingBoxAction on g_volumeDataRoot.
  SoVolumeData* volumeData = searchNode<SoVolumeData>( node );
  if ( volumeData != NULL )
  {
    return volumeData->extent.getValue();
  }
  else
  {
    // Use fake viewport for SoGetBoundingBoxAction. see SoGetBoundingBoxAction
    // constructor for details.
    SbViewportRegion fakeViewportRegion(1, 1);
    SoGetBoundingBoxAction gba( fakeViewportRegion );
    gba.apply( node );
    return gba.getBoundingBox();
  }
}

