/*----------------------------------------------------------------------------------------
Example program.
Purpose : Demonstrate how to create and use a multi volumeData and m_volumeRender node.
author : Thierry Dufour
August 2002
----------------------------------------------------------------------------------------*/

//header files
#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoSphere.h>
#include <Inventor/nodes/SoCube.h>
#include <Inventor/nodes/SoMaterial.h>
#include <Inventor/nodes/SoTranslation.h>
#include <Inventor/nodes/SoRotation.h>
#include <VolumeViz/nodes/SoVolumeGroup.h>
#include <VolumeViz/nodes/SoVolumeData.h>
#include <VolumeViz/nodes/SoVolumeRender.h>
#include <LDM/nodes/SoTransferFunction.h>
#include <VolumeViz/nodes/SoVolumeRendering.h>
#include <DialogViz/SoDialogVizAll.h>

#include <Inventor/helpers/SbFileHelper.h>

Widget buildInterface(Widget);
void releaseInterface();

SoVolumeGroup        *m_volumeGroup;
SoVolumeRender       *m_volumeRender1;
SoVolumeRender       *m_volumeRender2;
SoMaterial           *m_material1;
SoMaterial           *m_material2;
SoTranslation        *m_translation;
SoRotation           *m_rotation;
SoVolumeData         *m_volumeData1,*m_volumeData2;
//main function
#include <Inventor/SoWinApp.h>


int main(int, char **argv)
{
  //create the window
  Widget myWindow = SoXt::init(argv[0]);
  if (!myWindow) return 0;
    
  //initialisation of VolumeViz and DialogViz extensions
  SoVolumeRendering::init();
  SoDialogViz::init();

  m_volumeData1 = new SoVolumeData();
  m_volumeData1->fileName = SbFileHelper::expandString("$OIVHOME/examples/data/VolumeViz/agipAVS.fld");
  float transparency = 0.98f;

  m_volumeData2 = new SoVolumeData();
  m_volumeData2->fileName = SbFileHelper::expandString("$OIVHOME/examples/data/VolumeViz/agipAVS.fld");

  //use of a predefined colorMap with the SoTransferFunction
  SoTransferFunction* transferFunction1 = new SoTransferFunction;
  transferFunction1->predefColorMap = SoTransferFunction::STANDARD;
  //pTransFunc1->minValue = 1; pTransFunc1->maxValue = 255;
  SoTransferFunction* transferFunction2 = new SoTransferFunction;
  transferFunction2->predefColorMap = SoTransferFunction::TEMPERATURE;
  transferFunction2->minValue = 15;
  transferFunction2->maxValue = 255;

  // Top Scene Graph
  SoSeparator *root = new SoSeparator;
  root->ref();
  
  SoSphere *sphere = new SoSphere;
  sphere->radius = 0.5;
  
  SoSeparator *volumeSep = new SoSeparator;
      
  root->addChild(sphere);
  root->addChild(volumeSep);

  // VolumeViz Scene Graph
  m_material1 = new SoMaterial;
  m_material1->transparency = transparency;
  m_material2 = new SoMaterial;
  m_material2->transparency = transparency;

  m_volumeGroup = new SoVolumeGroup;
  m_volumeGroup->multiVolumes = FALSE;

  m_translation = new SoTranslation;
  m_translation->translation = SbVec3f(3,0,0);

  m_rotation = new SoRotation;

  m_volumeRender1 = new SoVolumeRender;
  m_volumeRender1->samplingAlignment = SoVolumeRender::VIEW_ALIGNED;
  m_volumeRender2 = new SoVolumeRender;
  m_volumeRender2->samplingAlignment.connectFrom( &m_volumeRender1->samplingAlignment );

  //volumeSep->addChild(volumeData);
  volumeSep->addChild(m_volumeGroup);

  m_volumeGroup->addChild(m_volumeData1);
  m_volumeGroup->addChild(transferFunction1);
  m_volumeGroup->addChild(m_material1);
  m_volumeGroup->addChild(m_volumeRender1);
  m_volumeGroup->addChild(m_translation);
  m_volumeGroup->addChild(m_rotation);
  m_volumeGroup->addChild(m_volumeData2);
  m_volumeGroup->addChild(transferFunction2);
  m_volumeGroup->addChild(m_material2);
  m_volumeGroup->addChild(m_volumeRender2);

  // Set up viewer
  Widget parent = buildInterface(myWindow);
  SoXtExaminerViewer *myViewer = new SoXtExaminerViewer(parent);

  myViewer->setTransparencyType(SoGLRenderAction::NO_SORT);
  myViewer->setSceneGraph(root);
  myViewer->setTitle("Multi Volumes");
  myViewer->viewAll();
  myViewer->show();

  SoXt::show(myWindow);
  SoXt::mainLoop();
  root->unref();
  delete myViewer;
  releaseInterface();
  SoVolumeRendering::finish();
  SoDialogViz::finish();
  SoXt::finish();

  return 0;
}

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////

class myAuditorClass : public SoDialogAuditor
{
  void dialogCheckBox(SoDialogCheckBox* cpt);
  void dialogRealSlider(SoDialogRealSlider* cpt);
  void dialogIntegerSlider(SoDialogIntegerSlider* cpt);
};

void
myAuditorClass::dialogCheckBox(SoDialogCheckBox* cpt)
{
  if (cpt->auditorID.getValue() == "MultiVolumes")
    m_volumeGroup->multiVolumes = cpt->state.getValue();
  else if (cpt->auditorID.getValue() == "ViewAlignedSlices")
    m_volumeRender1->samplingAlignment = cpt->state.getValue() ? SoVolumeRender::VIEW_ALIGNED : SoVolumeRender::DATA_ALIGNED;
}

void
myAuditorClass::dialogRealSlider(SoDialogRealSlider* cpt)
{
  if (cpt->auditorID.getValue() == "ObjectSpacing")
    m_translation->translation = SbVec3f(cpt->value.getValue(),0,0);
  else if (cpt->auditorID.getValue() == "Transparency1")
    m_material1->transparency = cpt->value.getValue();
  else if (cpt->auditorID.getValue() == "Transparency2")
    m_material2->transparency = cpt->value.getValue();
}

void
myAuditorClass::dialogIntegerSlider(SoDialogIntegerSlider* cpt)
{
  m_rotation->rotation = SbRotation(SbVec3f(1,0,0),3.14f/180*cpt->value.getValue());
}

SoGroup *g_myGroup = NULL;
myAuditorClass *g_myAuditor = NULL;

void releaseInterface()
{
  delete g_myAuditor;
  SO_UNREF_RESET(g_myGroup);
}

Widget
buildInterface(Widget window)
{
  SoInput myInput;
  if (! myInput.openFile( "$OIVHOME/examples/source/VolumeViz/multiVolumes/multiVolumesDialog.iv" ))
    return NULL;
  g_myGroup = SoDB::readAll( &myInput );
  if (! g_myGroup)
    return NULL;
  g_myGroup->ref();
  SoTopLevelDialog *myTopLevelDialog = (SoTopLevelDialog *)g_myGroup->getChild( 0 );

  g_myAuditor = new myAuditorClass;
  myTopLevelDialog->addAuditor(g_myAuditor);

  SoDialogCustom *customNode = (SoDialogCustom *)myTopLevelDialog->searchForAuditorId(SbString("Viewer"));

  myTopLevelDialog->buildDialog( window, customNode != NULL );
  myTopLevelDialog->show();

  return customNode ? customNode->getWidget() : window;
}

