#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/SoPreferences.h>

#include <VolumeViz/nodes/SoVolumeData.h>
#include <VolumeViz/nodes/SoVolumeRenderingQuality.h>
#include <VolumeViz/nodes/SoVolumeIsosurface.h>
#include <VolumeViz/nodes/SoFenceSlice.h>
#include <Inventor/actions/SoSearchAction.h>

#include <DialogViz/SoDialogVizAll.h>

#include "utils.h"

#include <Inventor/STL/algorithm>

#include <Inventor/helpers/SbFileHelper.h>

SbString DataFile = "$OIVHOME/examples/source/VolumeViz/simpleFenceSlice/scene.iv";


/*********************************************************************************/
int main(int, char **argv)
{
  SoTopLevelDialog *myTopLevelDialog;
  Widget myWindow = SoXt::init(argv[0]);
  if (!myWindow)
    return 0;

  SoVolumeRendering::init();
  SoDialogViz::init();
  SoLDMGlobalResourceParameters::setViewCulling(FALSE);
  SoLDMGlobalResourceParameters::setViewpointRefinement(FALSE);
  SoLDMGlobalResourceParameters::setScreenResolutionCulling(FALSE);

  SoSeparator* scene = readFile(DataFile.toLatin1());
  if(!scene)
  {
    std::cerr << DataFile.toStdString() << " not found" << std::endl;
    return 0;
  }

  SbString InterfaceName = "$OIVHOME/examples/source/VolumeViz/simpleFenceSlice/interface.iv";
  Widget parent = buildInterface(myWindow, InterfaceName.toLatin1(), "Viewer", &myTopLevelDialog);

  SoSeparator *root = new SoSeparator;
  root->ref();
  root->addChild(scene);

  std::vector<SoFenceSlice*> fsVec = searchNodes<SoFenceSlice>(scene);

  SoDialogCheckBox *pChkBox;
  pChkBox = (SoDialogCheckBox *)myTopLevelDialog->searchForAuditorId("bump");
  for ( size_t i = 0; i < fsVec.size(); i++ )
    fsVec[i]->enableBumpMapping.connectFrom(&pChkBox->state);

  // Set up viewer:
  SoXtExaminerViewer *myViewer = new SoXtExaminerViewer(parent);
  myViewer->setSceneGraph(root);
  myViewer->setTitle("Fence Slice");
  myViewer->show();

  SoXt::show(myWindow);
  SoXt::mainLoop();
  delete myViewer;
  root->unref();
  SoVolumeRendering::finish();
  SoDialogViz::finish();
  SoXt::finish();
  return 0;
}


