#ifndef UTILS_H
#define UTILS_H

#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/actions/SoSearchAction.h>
#include <DialogViz/SoDialogVizAll.h>

extern SoSeparator *readFile(const char *filename);
extern Widget buildInterface(Widget window, const char *filename, const char* viewer,
                             SoTopLevelDialog** myTopLevelDialog);

template<typename T>
std::vector<T*>
searchNodes(SoNode* scene)
{
  SoSearchAction* sa = new SoSearchAction;
  sa->setType(T::getClassTypeId());
  sa->setInterest(SoSearchAction::ALL);

  sa->apply(scene);

  const SoPathList& path = sa->getPaths();
  if ( path.getLength() == 0 )
  {
    std::cerr << T::getClassTypeId().getName().getString() << " not found" << std::endl;
    exit(0);
  }

  std::vector<T*> ret;
  for ( int i = 0; i < path.getLength(); i++ )
     ret.push_back(dynamic_cast<T*>(path[i]->getTail()));

  delete sa;
  return ret;
}

template<typename T>
T*
searchNode(SoNode* scene)
{
  std::vector<T*> ret = searchNodes<T>(scene);
  if ( ret.empty() )
    return NULL;
  return ret[0];
}

#endif


